/**
 * 张江以外布局情况
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';


const zjBeyondLayoutSchema = new Schema({
    id:{type:String, index:true},//标识
    uscc:{type:String, index:true},//孵化器uscc
    name:{type:String, index:true},//运营机构名称
    city:String,//布局城市
    area:Number,//空间面积
    operationMode:Number,//运营模式
});

var zjBeyondLayoutModel;
export function initModel(){
    zjBeyondLayoutModel = baseDB.model('zjBeyondLayout', zjBeyondLayoutSchema);
    zjBeyondLayoutModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await zjBeyondLayoutModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}
 

/**
 * 根据id获取数据
 * @param id 
 * @returns 
 */
export async function findOneData(id:string) {
    return await zjBeyondLayoutModel.selectOnceData({id});
}


/**
 * 根据条件获取列表
 * @param param 
 * @returns 
 */
export async function findListDataByParam(param) {
    return await zjBeyondLayoutModel.find(param);
}


/**
 * 根据id删除
 * @param id 
 */
export async function deleteDataById(id:string) {
    await zjBeyondLayoutModel.deleteOne({id});   
}


/**
 * 添加张江以外布局情况
 * @param id 
 * @param uscc 
 * @param name 
 * @param city 
 * @param area 
 * @param operationMode 
 */
export async function addData(id:string, uscc:string, name:string, city:string, area:number, operationMode:number) {
    let addInfo = {id, uscc, name, city, area, operationMode};
    await zjBeyondLayoutModel.create(addInfo);
}


/**
 * 分页获取 张江以外布局情况
 * @param param 
 * @param skipCount 
 * @returns 
 */
export async function findZjBeyondLayoutListByParamToPage(param, skipCount:number) {
    return await zjBeyondLayoutModel.find(param).skip(skipCount).limit(10);;
}


/**
 * 获取符合条件的张江以外布局情况数据
 * @param param 
 * @returns 
 */
export async function getZjBeyondLayoutCountByParam(param) {
    return await zjBeyondLayoutModel.find(param).countDocuments();
}
