/**
 * 大学/科研院所合作机构
 */


import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';


const icrSchema = new Schema({
    id:{type:String, index:true},//标识
    uscc:{type:String, index:true},//孵化器uscc
    name:{type:String, index:true},//运营机构名称
    po:String,//合作机构
    ce:String,//合作企业
    cMode:{type:[Number], default:[]},//合作方式
    cAchievements:String,//合作成果
    startTimeMs:Number,//开始时间
});

var icrModel;
export function initModel(){
    icrModel = baseDB.model('icr', icrSchema);
    icrModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await icrModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 根据id获取大学/科研院所合作机构数据
 * @param id 
 * @returns 
 */
export async function findOneData(id:string) {
    return await icrModel.selectOnceData({id});
}


/**
 * 根据条件获取大学/科研院所合作机构列表
 * @param param 
 * @returns 
 */
export async function findListDataByParam(param) {
    return await icrModel.find(param);
}


/**
 * 根据id 删除 大学/科研院所合作机构 数据
 * @param id 
 */
export async function deleteDataById(id:string) {
    await icrModel.deleteOne({id});   
}


/**
 * 添加 大学/科研院所合作机构
 * @param id 
 * @param uscc 
 * @param name 
 * @param po 
 * @param ce 
 * @param cMode 
 * @param startTimeMs 
 */
export async function addData(id:string, uscc:string, name:string, po:string, ce:string, cMode, startTimeMs:number) {
    let addInfo = {id, uscc, name, po, ce, cMode, startTimeMs};
    await icrModel.create(addInfo);
}

/**
 * 分页获取 大学/科研院所合作机构
 * @param param 
 * @param skipCount 
 * @returns 
 */
export async function findIcrListByParamToPage(param, skipCount:number) {
    return await icrModel.find(param).skip(skipCount).limit(10);;
}


/**
 * 查看符合条件的大学/科研院所合作机构 数量
 * @param param 
 * @returns 
 */
export async function getIcrCountByParam(param) {
    return await icrModel.find(param).countDocuments();
}