/**
 * 国际化登记
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';


const i18nRegisterSchema = new Schema({
    id:{type:String, index:true},//标识
    uscc:{type:String, index:true},//孵化器uscc
    name:{type:String, index:true},//运营机构名称
    country:String,//国家
    partners:String,//合作机构
    cMode:String,//合作方式
    cAchievements:String,//合作成果
});

var i18nRegisterModel;
export function initModel(){
    i18nRegisterModel = baseDB.model('fuHuaQiI18nRegister', i18nRegisterSchema);
    i18nRegisterModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await i18nRegisterModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 根据id获取数据 可用save保存
 * @param id 
 * @returns 
 */
export async function findOneI18nRegister(id:string) {
    return await i18nRegisterModel.selectOnceData({id});
}


/**
 * 获取符合条件列表
 * @param param 
 * @returns 
 */
export async function findI18nRegisterListByParam(param) {
    return await i18nRegisterModel.find(param);
}


/**
 * 根据id删除
 * @param id 
 */
export async function deleteI18nRegisterListById(id:string) {
    await i18nRegisterModel.deleteOne({id});   
}


/**
 * 添加国际化登记
 * @param id 
 * @param uscc 
 * @param name 
 * @param country 
 * @param partners 
 * @param cMode 
 * @param cAchievements 
 */
export async function addRegister(id:string, uscc:string, name:string, country:string, partners:string, cMode:string, cAchievements:string) {
    let addInfo = {id, uscc, name, country, partners, cMode, cAchievements};
    await i18nRegisterModel.create(addInfo);
}

/**
 * 分页
 * @param param 
 * @param skipCount 
 * @returns 
 */
export async function findI18nRegisterListByParamToPage(param, skipCount:number) {
    return await i18nRegisterModel.find(param).skip(skipCount).limit(10);;
}


/**
 * 获取符合条件的国际化登录数量
 * @param param 
 * @returns 
 */
export async function getI18nRegisterCountByParam(param) {
    return await i18nRegisterModel.find(param).countDocuments();
}


/**
 * 去重拥有的国际化登录uscc
 * @returns {"usccxxxx":1}
 */
export async function distinctFuHuaQiRegister() {
    let list = await i18nRegisterModel.distinct("uscc");
    let map = {};
    list.forEach(uscc => {
        map[uscc] = 1;
    });
    return map;
}