/**
 * 孵化器标签
 */


import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const fuHuaQiLabelLogSchema = new Schema({
    uscc:{type:String, index:true},
    labelId:String,
    road:Number,
    ct:Number,
    desc:String//描述
});


var fuHuaQiLabelLogModel;
export function initModel(){
    fuHuaQiLabelLogModel = baseDB.model('fuHuaQiLabelLog', fuHuaQiLabelLogSchema);
    fuHuaQiLabelLogModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await fuHuaQiLabelLogModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


export async function addManyLabelLog(addList:object) {
    await fuHuaQiLabelLogModel.insertMany(addList);
}

export async function addOnceLabelLog(uscc:string, labelId:string, road:number, desc:string) {
    await fuHuaQiLabelLogModel.create({uscc, labelId, road, desc, ct:new Date().valueOf() });
}


export async function findLabelLogByParam(param) {
    return await fuHuaQiLabelLogModel.find(param);
}