/**
 * 企业需求
 */
import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const demandSchema = new Schema({
    id:String,//标识
    fuHuaQiUscc:String,//孵化器uscc
    uscc:{type:String, index:true},//企业uscc
    enterpriseName:String,
    createTime:Number,
    enterpriseType:{type:Number},//VISITENTERPRISETYPE
    demand:{type:[Number], default:[]},//企业需求
    demandDesc:String
});


var demandModel;
export function initModel(){
    demandModel = baseDB.model('demand', demandSchema);
    demandModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await demandModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


/**
 * 查询孵化器分数信息
 * @param uscc 孵化器统一信用代码
 * @returns 
 */
export async function findOne(param) {
    return await demandModel.selectOnceData(param);
}

/**通过条件查询孵化器得分信息 */
export async function findByParam(param) {
    return await demandModel.find(param);
}

export async function findCountByParam(param) {
    return await demandModel.find(param).countDocuments();
}

export async function createDataByParam(param) {
    return await demandModel.create(param);
}


export async function removeOneData(id:string) {
    return await demandModel.deleteOne({id});
}

export async function findEnterpriseListToPage(selectParam, skipCount) {
    return await demandModel.find(selectParam).skip(skipCount).limit(10);
}