/**
 * 企业创始团队
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';

const initialTeamSchema = new Schema({
    id:{type:String, index:true}, //id标识
    uscc:{type:String, index:true},//企业uscc
    name:String,//企业名称
    type:Number,//创始团队人才类型
    memberName:String,//成员姓名
    memberSex:Number,//成员性别
    memberAge:Number,//成员年龄  出生年月时间戳
    memberDEGREE:Number,//成员最高学历
    memberSchool:String,//毕业学校
    des:String,//履历描述
},{_id:false});


var initialTeamModel;
export function initModel(){
    initialTeamModel = baseDB.model('enterpriseInitialTeam', initialTeamSchema);
}

/**
 * 查询 企业的创始团队列表
 * @param uscc 
 * @returns 
 */
export async function findEnterpriseInitialTeam(uscc:string) {
    return await initialTeamModel.find({uscc});
}


/**
 * 根据id删除创始团队数据
 * @param id 
 */
export async function deleteEnterpriseInitialTeamMember(id:string) {
    await initialTeamModel.deleteOne({id});
}


/**
 * 添加多个创始团队数据
 * @param teams 
 */
export async function addMoneyEnterpriseInitialTeam(teams) {
    await initialTeamModel.insertMany(teams);
}


/**
 * 修改多个创始团队信息
 * @param updateTeams 
 */
export async function updateManyEnterpriseInitialTeam(updateTeams) {
    for (let i = 0; i < updateTeams.length; i++) {
        let info = updateTeams[i];
        let id = info.id;
        delete info.id;
        await initialTeamModel.updateOne({id}, info );
    }
}


/**
 * 删除多个创始团队信息
 * @param deleteTeams 
 */
export async function deleteManyEnterpriseInitialTeam(deleteTeams) {
    for (let i = 0; i < deleteTeams.length; i++) {
        let info = deleteTeams[i];
        let id = info.id;
        await initialTeamModel.deleteOne({id});
    }
}


/**
 * 分页
 * @param param 
 * @param skipCount 
 * @returns 
 */
export async function findEnterpriseInitialTeamsByParamToPage(param, skipCount:number) {
    return await initialTeamModel.find(param).skip(skipCount).limit(10);
}

/**
 * 获取符合条件的总数
 * @param param 
 * @returns 
 */
export async function findEnterpriseInitialTeamsCountByParamToPage(param) {
    return await initialTeamModel.find(param).countDocuments();
}


/**
 * 获取符合条件的列表
 * @param param 
 * @returns 
 */
export async function findEnterpriseInitialTeamsByParam(param) {
    return await initialTeamModel.find(param);
}


/**
 * 统计人才类型数量
 * @returns 
 */
export async function statsEnterpriseInitalTeamsType() {
    let statsCountList = await initialTeamModel.aggregate([
        {"$group":{_id:"$type", count:{"$sum":1} } }
    ]);
    return statsCountList;
}