/**
 * 企业标签
 */


import {Schema} from 'mongoose';
import { baseDB } from '../../db/mongo/dbInit';


const enterpriseLabelLogSchema = new Schema({
    uscc:{type:String, index:true},
    labelId:String,
    road:Number,
    ct:Number,
    desc:String
});


var enterpriseLabelLogModel;
export function initModel(){
    enterpriseLabelLogModel = baseDB.model('enterpriseLabelLog', enterpriseLabelLogSchema);
    enterpriseLabelLogModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await enterpriseLabelLogModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}


export async function addManyLabelLog(addList:object) {
    await enterpriseLabelLogModel.insertMany(addList);
}

export async function addOnceLabelLog(uscc:string, labelId:string, road:number, desc:string) {
    await enterpriseLabelLogModel.create({uscc, labelId, road, desc, ct:new Date().valueOf() });
}

export async function findLabelLogByParam(param) {
    return await enterpriseLabelLogModel.find(param);
}