/**
 * 埋点主要逻辑
 */

import { logError } from "../util/log";
import { post } from "../util/request";

const Sign = "xxxx8901231kldosdjkfsdlk";


/**
 * 添加孵化器埋点
 * @param uid 
 * @param pointId 
 * @param p1 
 * @param p2 
 * @param p3 
 */
export async function addFuHuaQiPoint(uid:string, pointId:number, p1, p2?, p3?) {
    let param:any = {pid:pointId, uid, ct:new Date().valueOf()};
    if (p1 != null || p1 != undefined) {
        if (typeof p1 == "object") param.p1 = JSON.stringify(p1);
        else if (typeof p1 == "boolean" || typeof p1 == "number") param.p1 = p1.toString();
        else if (typeof p1 == "string") param.p1 == p1;
    }
    if (p2 != null || p2 != undefined) {
        if (typeof p2 == "object") param.p2 = JSON.stringify(p2);
        else if (typeof p2 == "boolean" || typeof p2 == "number") param.p2 = p2.toString();
        else if (typeof p2 == "string") param.p2 == p2;
    }
    if (p3 != null || p3 != undefined) {
        if (typeof p3 == "object") param.p3 = JSON.stringify(p3);
        else if (typeof p3 == "boolean" || typeof p3 == "number") param.p3 = p3.toString();
        else if (typeof p3 == "string") param.p3 == p3;
    }
    post('http://localhost:7078/point/fuhuaqi/add', {pointInfo:param, pointId}, {sign:Sign});
}


/**
 * 添加企业埋点
 * @param uid 
 * @param pointId 
 * @param p1 
 * @param p2 
 * @param p3 
 */
export async function addEnterprisePoint(uid:string, pointId:number, p1, p2?, p3?) {
    let param:any = {p1, pid:pointId, uid, ct:new Date().valueOf()};
    if (p1 != null || p1 != undefined) {
        if (typeof p1 == "object") param.p1 = JSON.stringify(p1);
        else if (typeof p1 == "boolean" || typeof p1 == "number") param.p1 = p1.toString();
        else if (typeof p1 == "string") param.p1 == p1;
    }
    if (p2 != null || p2 != undefined) {
        if (typeof p2 == "object") param.p2 = JSON.stringify(p2);
        else if (typeof p2 == "boolean" || typeof p2 == "number") param.p2 = p2.toString();
        else if (typeof p2 == "string") param.p2 == p2;
    }
    if (p3 != null || p3 != undefined) {
        if (typeof p3 == "object") param.p3 = JSON.stringify(p3);
        else if (typeof p3 == "boolean" || typeof p3 == "number") param.p3 = p3.toString();
        else if (typeof p3 == "string") param.p3 == p3;
    }
    post('http://localhost:7078/point/enterprise/add', {pointInfo:param, pointId}, {sign:Sign});
}



/**
 * 获取埋点数据
 * @param type 类型 
 * @param pointId 埋点id
 * @param param 参数
 * @returns 
 */
export async function getPointDataByParam(type:number, pointId:number, param) {
    let url = 'http://localhost:7078/point/query';
    let result:any = await post(url, {type, pointId, param}, {sign:Sign});

    if (!result.success || result.code != 200) {
        logError(url, "请求失败", JSON.stringify(result) );
        console.log(url, "请求失败", JSON.stringify(result));
        return [];
    }
    return result.data.dataList || [];
}