/**
 * 管委会移动端-孵化器管理
 * 6.0版本更新
 */
import moment = require("moment");
import * as configEnum from "../../../config/enum";
import { findLabelLogByParam } from "../../../data/fuHuaQi/fuHuaQiLabelLog";
import { findFuHuaQiByUSCC, findFuHuaQiCount, findFuHuaQiListByPage } from "../../../data/fuHuaQi/fuhuaqi";
import { getLabelNamMap } from "../../../data/label";
import { changeAddToString } from "../../../tools/system";
import { extractData } from "../../../util/piecemeal";
import { changeEnumManyValue, changeEnumValue, eccEnumValue } from "../../../util/verificationEnum";
import { findEnterpriseCount } from "../../../data/enterprise/enterprise";
import { ENTERPRISESYSTEMLABEL, LABELGOAL } from "../../../config/enum/labelEnum";


/**
 * 孵化器库-孵化器详情
 * @param uscc 
 */
export async function fuHuaQiInfomation(uscc:string) {
    let dbData = await findFuHuaQiByUSCC(uscc);
    let config = {
        name:{key:"名称"},
        operationName:{key:"运营机构名称"},
        uscc:{key:"统一信用代码"},
        incubatedAcreage:{key:"在孵面积㎡)"},
        acreageTotal:{key:"孵化器总面积㎡)"},
        acreagePersonalUse:{key:"孵化器自用面积㎡)"},
        institutionalNature:{key:"机构性质"},
        operationModel:{key:"运营模式 "},
        industry:{key:"孵化领域"},
        logonTime:{key:"注册时间"},
        identificationTime:{key:"认定时间"},
        lv:{key:"孵化器级别"},
        caiLiHuGuanDi:{key:"财力户管地"},
        fuHuazhuCeDiZhi:{key:"孵化注册地址"},
        fuHuaLianXiDiZhi:{key:"孵化联系地址"},
        liaison:{key:"联系人"},
        liaisonPhone:{key:"联系电话"},
        personInCharge:{key:"负责人"},
        personInChargePhone:{key:"负责人联系电话"},
        foundingTeamType:{key:"创业团队类型"},
    };
  
    let fuHuaQiInfo:any = await extractData(config, dbData, false);

    /**枚举转换 */
    //孵化领域
    fuHuaQiInfo.industry = changeEnumManyValue(configEnum.FUHUAINDUSTRY, fuHuaQiInfo.industry);
    if (fuHuaQiInfo.industry.length > 1) fuHuaQiInfo.industryStr = "多领域";
    else fuHuaQiInfo.industryStr = fuHuaQiInfo.industry[0];

    //孵化器性质
    fuHuaQiInfo.institutionalNature = changeEnumValue(configEnum.INSTITUTIONALNATURE, fuHuaQiInfo.institutionalNature);
    //f孵化器级别
    fuHuaQiInfo.lv = changeEnumValue(configEnum.FUHUAQILV, fuHuaQiInfo.lv);
    //孵化器运营模式
    fuHuaQiInfo.operationModel = changeEnumManyValue(configEnum.OPERATIONMODEL, fuHuaQiInfo.operationModel);
    //注册地址
    fuHuaQiInfo.fuHuazhuCeDiZhiStr = changeAddToString(fuHuaQiInfo.fuHuazhuCeDiZhi);
    //联系地址
    fuHuaQiInfo.fuHuaLianXiDiZhiStr = changeAddToString(fuHuaQiInfo.fuHuaLianXiDiZhi);
    //创业团队类型
    fuHuaQiInfo.foundingTeamType = changeEnumValue(configEnum.TEAM, fuHuaQiInfo.foundingTeamType);

    /**孵化信息 */
    //在孵企业
    fuHuaQiInfo.zaiFuQiYe = await findEnterpriseCount({fuHuaQiUscc:uscc, });
    //虚拟企业
    fuHuaQiInfo.xuNiQiYe = await findEnterpriseCount({fuHuaQiUscc:uscc, state:configEnum.FUHUASTATE.虚拟孵化 });
    //实体企业
    fuHuaQiInfo.shiTiQiYe = await findEnterpriseCount({fuHuaQiUscc:uscc, state:configEnum.FUHUASTATE.实体孵化});
    //迁出企业
    fuHuaQiInfo.qianChuQiYe = await findEnterpriseCount({fuHuaQiUscc:uscc, state:configEnum.FUHUASTATE.迁出});
    //入驻非孵
    fuHuaQiInfo.ruZhuFeiFu = await findEnterpriseCount({fuHuaQiUscc:uscc, state:configEnum.FUHUASTATE.实体孵化, labels: {"$elemMatch": {  "labelId":ENTERPRISESYSTEMLABEL.入驻非孵, "state":true  }} });
    //累计孵化
    fuHuaQiInfo.leiJiFuHua = await findEnterpriseCount({fuHuaQiUscc:uscc, state:configEnum.FUHUASTATE.迁出, moveOutType:configEnum.MOVEOUTTYPE.毕业迁出});
   
    //创始团队
    fuHuaQiInfo.foundingTeam = [];
    if (dbData.foundingTeam) {
        dbData.foundingTeam.forEach(info => {
            fuHuaQiInfo.foundingTeam.push(
                {
                    memberName:info.memberName,
                    memberSex:changeEnumValue(configEnum.SEX, info.memberSex),
                    memberAge:info.memberAge,
                    memberDEGREE:changeEnumValue(configEnum.DEGREE, info.memberDEGREE),
                    memberSchool:info.memberSchool,
                    des:info.des
                }
            );
        });
        
    }

    fuHuaQiInfo.logonTime = moment(fuHuaQiInfo.logonTime).format("YYYY/MM/DD");
    fuHuaQiInfo.identificationTime = moment(fuHuaQiInfo.identificationTime).format("YYYY/MM/DD");


    //标签动态
    let dbLogList = await findLabelLogByParam({uscc:fuHuaQiInfo.uscc});

    let labelLogList = [];
    let labelNameMap = await getLabelNamMap(LABELGOAL.孵化器);
    dbLogList.forEach(info => {
        let { labelName } = labelNameMap[info.labelId];
        labelLogList.push({
            time:moment(info.ct).format("YYYY-MM-DD"),
            name:labelName,
            desc:info.desc,
            road:info.road > 2 ? "失效" : "生效"
        });
    });

    //标签
    fuHuaQiInfo.labels = [];
    if (dbData.labels && dbData.labels.length) {
        dbData.labels.forEach(info => {
        if (labelNameMap[info.labelId] && labelNameMap[info.labelId].state) {
            fuHuaQiInfo.labels.push({
                key:labelNameMap[info.labelId].labelName,
                state:info.state
            });
        }
        
        });
    }

    return {fuHuaQiInfo, labelLogList};
}


/**
 * 孵化器管理列表
 * @param name 
 * @param pageNumber 
 * @param labelId 
 * @returns 
 */
export async function fuHuaQiList(name:string, pageNumber:number, labelId:string) {
    
    let param:any = {uscc:{"$ne":"123456789123456789"}};
    if ( labelId ) {
        param.labels =  {"$elemMatch": {  "labelId":labelId, "state":true  }};
    }
    if (name) {
        param.name =  {"$regex":`${name}`};
    }

    let dbList = await findFuHuaQiListByPage(param, (pageNumber-1)*10);
    let dataCount = await findFuHuaQiCount(param);
    let labelNameMap = await getLabelNamMap(LABELGOAL.孵化器);
    const config = {
        uscc:{key:"统一信用代码"},
        operationName:{key:"企业名称"},
        logonTime:{key:"注册时间"},
        lv:{key:"孵化器级别"},
        fuHuazhuCeDiZhi:{key:"孵化注册地址"},
        fuHuaLianXiDiZhi:{key:"孵化联系地址"}
    };
    let dataList = [];
    dbList.forEach(info => {
        let itemData:any = extractData(config, info, false);
        //孵化注册地址
        itemData.fuHuazhuCeDiZhiStr = changeAddToString(info.fuHuazhuCeDiZhi);
        //孵化联系地址
        itemData.fuHuaLianXiDiZhiStr = changeAddToString(info.fuHuaLianXiDiZhi);
        if (!itemData.fuHuazhuCeDiZhiStr && info.hatchingGround && info.hatchingGround[0]) {
            itemData.fuHuazhuCeDiZhiStr = changeAddToString(info.hatchingGround[0].personInChargeAddress);
        }

        itemData.labels = [];
        if (info.labels && info.labels.length) {
            info.labels.forEach(info => {
                if (labelNameMap[info.labelId] && !labelNameMap[info.labelId].state) {
                    itemData.labels.push({
                        key:labelNameMap[info.labelId].labelName,
                        state:info.state
                    });
                }
            
            });
        }
        itemData.lv = changeEnumValue(configEnum.FUHUAQILV, info.lv);
        itemData.logonTime = moment(info.logonTime).format("YYYY/MM/DD");

        dataList.push(itemData);
    });

    return {dataList, dataCount}
}



