/**
 * 年度任务
 * 未来这里的任务列表要和其他两个任务和一起
 */

import moment = require("moment");
import { findDangJianTaskListByTaskId } from "../../../../data/fuHuaQi/monthTask/dangJian";
import { ERRORENUM } from "../../../../config/errorEnum";
import { BizError } from "../../../../util/bizError";
import { DANGJIANTASKTYPEENUM, YEARTASKTYPEENUM } from "../../../../config/enum";
import { changeEnumValue } from "../../../../util/verificationEnum";
import { findCustomTaskByTaskId } from "../../../../data/fuHuaQi/customTask";


/**   
 * 孵化器的任务列表 (待办任务)
 * 小程序端
 * @param uscc 孵化器统一信用
 * @returns [{key:1, title:'', list:[] }]
 */
export async function fuHuaQiYearTaskList(uscc:string) {
    let year = new Date().getFullYear();
    let taskId = `${uscc}${year}`;
    let taskInfo = await findDangJianTaskListByTaskId(taskId);
    

    let result = [];
    if (taskInfo && taskInfo.taskId && !taskInfo.draftLock) {
        //查询这个任务是否正在进行中
        let customTaskInfo = await findCustomTaskByTaskId(taskInfo.customTaskId);
        if (customTaskInfo && customTaskInfo.customTaskId) {
            let now = new Date().valueOf();
            if (now < customTaskInfo.startMs || now > customTaskInfo.endMs) {
                return {taskList:[]};
            }
        }
        result.push({
            title:"党建工作",
            key:YEARTASKTYPEENUM.党建任务,
            list:[
                {
                    name:changeEnumValue(DANGJIANTASKTYPEENUM, DANGJIANTASKTYPEENUM.众创孵化信息采集),
                    id:DANGJIANTASKTYPEENUM.众创孵化信息采集
                },
                {
                    name:changeEnumValue(DANGJIANTASKTYPEENUM, DANGJIANTASKTYPEENUM.在孵企业信息采集),
                    id:DANGJIANTASKTYPEENUM.在孵企业信息采集
                }
            ]
        });
    }
   
    return {taskList:result};
}



/**
 * 孵化器 已办任务列表
 * 小程序端  6.1
 * 只显示本周期 已经办理的任务
 * @param uscc 孵化器统一信用
 * @returns [{type:1, title:'', list:[] }]
 */
export async function fuHuaQiYearTaskCompletedList(uscc:string, selectTime:number) {
    let year = new Date().getFullYear();
    let taskId = `${uscc}${year}`;
    let taskInfo = await findDangJianTaskListByTaskId(taskId);
    let editable = new Date(selectTime).getFullYear() == new Date().getFullYear();

    let result = [];
    if (taskInfo && taskInfo.taskId && year == taskInfo.key) {
        result.push({
            title:"党建工作",
            key:YEARTASKTYPEENUM.党建任务,
            editable,
            list:[
                {
                    name:changeEnumValue(DANGJIANTASKTYPEENUM, DANGJIANTASKTYPEENUM.众创孵化信息采集),
                    id:DANGJIANTASKTYPEENUM.众创孵化信息采集
                },
                {
                    name:changeEnumValue(DANGJIANTASKTYPEENUM, DANGJIANTASKTYPEENUM.在孵企业信息采集),
                    id:DANGJIANTASKTYPEENUM.在孵企业信息采集
                }
            ]
        });
    }

    return {taskList:result};
}


/**
 * 孵化器 过期任务列表
 * 小程序端 6.1
 * 只显示上周期 过期任务
 * @param uscc 孵化器统一信用
 * @returns [{type:1, title:'', list:[] }]
 */
export async function fuHuaQiYearTaskPastdueList(uscc:string, selectTime) {
    let year =  new Date(selectTime).getFullYear();
    let taskId = `${uscc}${year}`;
    let taskInfo = await findDangJianTaskListByTaskId(taskId);

    let result = [];
    if (taskInfo && taskInfo.taskId && !taskInfo.draftLock) {
        result.push({
            title:"党建工作",
            key:YEARTASKTYPEENUM.党建任务,
            list:[
                {
                    name:changeEnumValue(DANGJIANTASKTYPEENUM, DANGJIANTASKTYPEENUM.众创孵化信息采集),
                    id:DANGJIANTASKTYPEENUM.众创孵化信息采集
                },
                {
                    name:changeEnumValue(DANGJIANTASKTYPEENUM, DANGJIANTASKTYPEENUM.在孵企业信息采集),
                    id:DANGJIANTASKTYPEENUM.在孵企业信息采集
                }
            ]
        });
    }
   
    return {taskList:result};
}



/**
 * 提交任务
 * 小程序端
 * @param uscc 孵化器统一信用代码
 * @param taskType 任务类型
 * @returns {isSuccess:true/false}
 */
export async function checkYearTask(uscc:string) {
    let year = new Date().getFullYear();
    let taskId = `${uscc}${year}`;
    let dangJianTaskInfo = await findDangJianTaskListByTaskId(taskId);
    
    /**提交限制 */
    if (!dangJianTaskInfo || !dangJianTaskInfo.taskId) throw new BizError(ERRORENUM.任务不存在, uscc, taskId);
    if ( dangJianTaskInfo.draftLock ) throw new BizError(ERRORENUM.不能重复提交任务, uscc);

    dangJianTaskInfo.draftLock = true;
    await dangJianTaskInfo.save();

    return {isSuccess:true};
}







