/**
 * 党建任务
 */

import * as eccParamConfig from "../../../config/eccParam/fuHuaQi";
import * as splitResultConfig from "../../../config/splitResultConfig";
import { STATEENUM } from "../../../config/enum";
import { NOTZHIBUTYPEENUM, SZZCFHJGSFCLDZBENUM, ZHIBUTYPEENUM } from "../../../config/enum/dangJianEnum";
import { ERRORENUM } from "../../../config/errorEnum";
import { findDangJianTaskListByTaskId } from "../../../data/fuHuaQi/monthTask/dangJian";
import { BizError } from "../../../util/bizError";
import { checkChange, extractData } from "../../../util/piecemeal";
import { eccEnumValue } from "../../../util/verificationEnum";
import { eccFormParam } from "../../../util/verificationParam";



/**
 * 党建任务-众创孵化信息采集
 * @param uscc 
 */
export async function replenishZhongChuang(uscc:string, param) {
    const FunName = '补充众创孵化信息采集';
    /**校验表单参数 */
    eccFormParam(FunName, eccParamConfig.DangJianZhongChuangConfig, param);
    /**校验枚举 */
    eccEnumValue(FunName, '董事长是党员', STATEENUM, param.zcdszdy);
    eccEnumValue(FunName, '众创孵化机构是否建设党建园地', STATEENUM, param.zcfhjgsfjsdjyd);
    eccEnumValue(FunName, '众创孵化机构是否成立党支部', STATEENUM, param.zcjgsfcldzs);
    eccEnumValue(FunName, '众创孵化机构党支部类型', SZZCFHJGSFCLDZBENUM, param.zcjgsfcldzslx);

    if (param.zcjgsfcldzs == STATEENUM.是) {
        eccEnumValue(FunName, '存在支部时众创孵化机构党支部类型', ZHIBUTYPEENUM, param.zcjgsfcldzslx);

        if (!param.zbmc) throw new BizError(ERRORENUM.参数错误, '缺少支部名称');
        if (param.dzbsfkzshyk) {
            if (param.hdcs == undefined || param.hdcs == null || param.cyrs == undefined || param.cyrs == null) {
                throw new BizError(ERRORENUM.参数错误, '活动人数或参与人数');
            }
        } else {
            param.hdcs = 0;//活动次数
            param.cyrs = 0;//参与人数
        }
    } else if (param.zcjgsfcldzs == STATEENUM.否) {
        eccEnumValue(FunName, '不存在支部时众创孵化机构党支部类型', NOTZHIBUTYPEENUM, param.zcjgsfcldzslx);
        param.zbmc = '';//支部名称
        param.dzbsfkzshyk = false;//党支部是否开展三会一课
        param.hdcs = 0;//活动次数
        param.cyrs = 0;//参与人数
    }

    const TaskId = `${uscc}${new Date().getFullYear()}`;
    let dangJianTaskInfo = await findDangJianTaskListByTaskId(TaskId);

    /**修改值 */
    let changeList = checkChange(param, dangJianTaskInfo);
    if ( !changeList.length ) throw new BizError(ERRORENUM.数据无更新, `${param.uscc}数据无更新`);
    changeList.forEach(key => {
        dangJianTaskInfo[key] = param[key];
    });
    await dangJianTaskInfo.save();

    return {isSuccess:true};
}


/**
 * 众创孵化信息采集 回显
 * @param uscc 
 */
export async function zhongChuangInfo(uscc:string) {
    const TaskId = `${uscc}${new Date().getFullYear()}`;
    let dangJianTaskInfo = await findDangJianTaskListByTaskId(TaskId);
    if (!dangJianTaskInfo || !dangJianTaskInfo.taskId) throw new BizError(ERRORENUM.未找到数据, `库中不存在uscc=${uscc}这个年度任务`);

    let dataInfo = extractData(splitResultConfig.DangJianZhongChuangConfig, dangJianTaskInfo, false);

    return {dataInfo};
}


/**
 * 党建任务-在孵企业信息采集
 * @param uscc 
 */
export async function replenishZaiFu(uscc:string, param) {
    const FunName = '补充在孵企业信息采集';
    /**校验表单参数 */
    eccFormParam(FunName, eccParamConfig.DangJianZaiFuConfig, param);
    /**校验枚举 */
    eccEnumValue(FunName, '在孵企业党建', STATEENUM, param.zfqydj);

    if ((param.dy70h+param.dy80h+param.dy90h) > param.zfqydysl) throw new BizError(ERRORENUM.党员年龄分布总和大于总数);

    if (param.zfqydj == STATEENUM.是) {
        if (!param.zfqydzbdjList.length) throw new BizError(ERRORENUM.参数错误, '缺少党支部信息');
        let itemConfig = {
            name:{type:"String"},//支部名称
            type:{type:"Number"},//支部类型
            count:{type:"Number"},//党员数量
            dzbsfkzshyk:{type:"Boolean"},//党支部是否开展三会一课
            hdcs:{type:"Number", notMustHave:true},//活动次数
            cyrs:{type:"Number", notMustHave:true},//参与人数
        };
        for (let i in param.zfqydzbdjList) {
            let item = param.zfqydzbdjList[i];
            eccFormParam(FunName+'党支部登记', itemConfig, item);
            eccEnumValue(FunName+'党支部登记', '支部类型', ZHIBUTYPEENUM, item.type);
            if (item.dzbsfkzshyk) {
                if (item.hdcs == undefined || item.hdcs == null || item.cyrs == undefined || item.cyrs == null) {
                    throw new BizError(ERRORENUM.参数错误, '活动人数或参与人数');
                }
            } else {
                item.hdcs = 0;//活动次数
                item.cyrs = 0;//参与人数
            }
        }
    } else {
        param.zfqydzbdjList = [];
    }


    const TaskId = `${uscc}${new Date().getFullYear()}`;
    let dangJianTaskInfo = await findDangJianTaskListByTaskId(TaskId);

    /**修改值 */
    let changeList = checkChange(param, dangJianTaskInfo);
    if ( !changeList.length ) throw new BizError(ERRORENUM.数据无更新, `${param.uscc}数据无更新`);
    changeList.forEach(key => {
        dangJianTaskInfo[key] = param[key];
    });
    await dangJianTaskInfo.save();

    return {isSuccess:true};
}


/**
 * 党建任务-在孵企业信息采集回显
 * @param uscc 
 */
export async function zaiFuInfo(uscc:string) {
    const TaskId = `${uscc}${new Date().getFullYear()}`;
    let dangJianTaskInfo = await findDangJianTaskListByTaskId(TaskId);
    if (!dangJianTaskInfo || !dangJianTaskInfo.taskId) throw new BizError(ERRORENUM.未找到数据, `库中不存在uscc=${uscc}这个年度任务`);

    let dataInfo = extractData(splitResultConfig.DangJianZaiFuConfig, dangJianTaskInfo, false);

    return {dataInfo};
}
