/**
 * 小程序端 孵化器入口 审核相关
 * 作者: lxm
 * 
 */

import * as businessData from "../../../data/enterprise/quarterTask/businessdata";
import { ENTERPRISEDECLARATIONTYPE } from "../../../config/enum";
import * as teamData from "../../../data/enterprise/quarterTask/team";
import { eccEnumValue } from "../../../util/verificationEnum";
import { eccFormParam } from "../../../util/verificationParam";
import * as eccFormParamConfig from "../../../config/eccParam/fuHuaQi";
import { BizError } from "../../../util/bizError";
import { ERRORENUM } from "../../../config/errorEnum";

function getCycle(cycleNumber:number) {
    if (!cycleNumber) return "-";
    let nameList = ["一", "二", "三", "四"];

    return `第${nameList[cycleNumber-1]}季度`;
}

/**
 * 待审核列表
 * @param uscc 孵化器统一信用代码
 */
export async function unauditedList(uscc:string, state:number, type:number ) {
    let query:any = {fhqIsSubmit:false, fuHuaQiUscc:uscc};

    if (state == 2) { //已填报 
        query.isSubmit = true;
    } else if (state == 3) { //未填报
        query.isSubmit = false;
    }

    let dataNumberLists = [
        {
            "key":1,//枚举值
            "value":`全部(0)`//按钮文本
        },
        {
            "key":2,//枚举值
            "value":`已填报(0)`//按钮文本
        },
        {
            "key":3,//枚举值
            "value":`未填报(0)`//按钮文本
        },
    ];

    return {dataNumberList:dataNumberLists, dataList:[]};

    let businessDataList = [];
    let teamDataList = []; 
    if (type == 2) {
        businessDataList = await businessData.findBusinessDataByParams(query);
    } else if (type == 3) {
        teamDataList = await teamData.findTeamDataByParams(query); 
    } else {
        businessDataList = await businessData.findBusinessDataByParams(query);
        teamDataList = await teamData.findTeamDataByParams(query); 
    }

    let dataList = [];
    businessDataList.forEach(info => {
        let { name, quarter, isSubmit, year, isUpdate } = info;
        dataList.push({
            name,
            uscc:info.uscc,
            typeStr:"经营状况",
            type:ENTERPRISEDECLARATIONTYPE.经营状况,
            cycle:getCycle(quarter),
            quarter,
            year,
            enterpriseSubmit:isSubmit ? "是" : "否",
            isUpdate:isUpdate
        });
    });
    
    
    teamDataList.forEach(info => {
        let { name, quarter, isSubmit, year, isUpdate } = info;
        dataList.push({
            name,
            uscc:info.uscc,
            typeStr:"团队信息",
            type:ENTERPRISEDECLARATIONTYPE.团队信息,
            cycle:getCycle(quarter),
            quarter,
            year,
            enterpriseSubmit:isSubmit ? "是" : "否",
            isUpdate:isUpdate
        });
    });

    /**组合dataNumberList */
    let businessSubmitCount = await businessData.findBusinessDataCountByParams({fhqIsSubmit:false, fuHuaQiUscc:uscc, isSubmit:true});
    let businessNotSubmitCount = await businessData.findBusinessDataCountByParams({fhqIsSubmit:false, fuHuaQiUscc:uscc, isSubmit:false});
    let teamSubmitCount = await teamData.findTeamDataCountByParams({fhqIsSubmit:false, fuHuaQiUscc:uscc, isSubmit:true});
    let teamNotSubmitCount = await teamData.findTeamDataCountByParams({fhqIsSubmit:false, fuHuaQiUscc:uscc, isSubmit:false});
    
    let dataNumberList = [
        {
            "key":1,//枚举值
            "value":`全部(${businessSubmitCount + businessNotSubmitCount + teamSubmitCount + teamNotSubmitCount})`//按钮文本
        },
        {
            "key":2,//枚举值
            "value":`已填报(${businessSubmitCount + teamSubmitCount})`//按钮文本
        },
        {
            "key":3,//枚举值
            "value":`未填报(${businessNotSubmitCount + teamNotSubmitCount})`//按钮文本
        },
    ];

    return { dataList, dataNumberList };
}



/**
 * 已审核列表
 * @param uscc 孵化器统一信用代码
 * @param year 年度
 * @param quarter 季度
 */
export async function auditCompletedList(uscc:string, year:number, quarter:number) {
    let query = {fhqIsSubmit:true, fuHuaQiUscc:uscc, year:year, quarter:quarter};

    let businessDataList = await businessData.findBusinessDataByParams(query);

    let dataList = [];
    businessDataList.forEach(info => {
        let { name, quarter } = info;
        dataList.push({
            name,
            typeStr:"经营状况",
            cycle:getCycle(quarter),
        });
    });

    let teamDataList = await teamData.findTeamDataByParams(query);
    teamDataList.forEach(info => {
        let { name, quarter } = info;
        dataList.push({
            name,
            typeStr:"团队信息",
            cycle:getCycle(quarter),
        });
    });

    return { dataList };
}


/**
 * 孵化器补充企业数据
 * @param fuHuaQiUscc 孵化器统一信用代码
 * @param uscc 企业统一信用代码
 * @param type 类型
 * @param form 数据表单
 */
export async function fuHuaQiReplenishEnterpriseDataDeclaration(fuHuaQiUscc:string, uscc:string, type:number, year:number, quarter:number, form ) {
    eccEnumValue("孵化器补充企业数据", "type", ENTERPRISEDECLARATIONTYPE, type);

    if (type == ENTERPRISEDECLARATIONTYPE.团队信息) {
        eccFormParam("孵化器补充企业数据-团队信息", eccFormParamConfig.FuHuaQiReplenishEnterpriseTeamDataConfig, form);
        let teamInfo = await teamData.findTeamByUsccAndTime(uscc, year, quarter);
        if (teamInfo.fuHuaQiUscc != fuHuaQiUscc) {}
        for (let key in eccFormParamConfig.FuHuaQiReplenishEnterpriseTeamDataConfig) {
            teamInfo[key] = form[key];
        }
        teamInfo.isUpdate = true;
        await teamInfo.save();

    } else {
        eccFormParam("孵化器补充企业数据-经营状况", eccFormParamConfig.FuHuaQiReplenishEnterpriseBusinessDataConfig, form);
        let businessInfo = await businessData.findBusinessDataByTimeAndUscc(uscc, year, quarter);
        if (businessInfo.fuHuaQiUscc != fuHuaQiUscc) {}

        for (let key in eccFormParamConfig.FuHuaQiReplenishEnterpriseBusinessDataConfig) {
            businessInfo[key] = form[key];
        }
        businessInfo.isUpdate = true;
        await businessInfo.save();

    }
    
    return { isSuccess:true };
}


/**
 * 通过校验
 * @param fuHuaQiUscc 孵化器统一信用代码
 * @param uscc 企业统一信用代码
 * @param type 类型 ENTERPRISEDECLARATIONTYPE
 * @param year 年度
 * @param quarter 季度
 * @returns 
 */
export async function fuHuaQiPass(fuHuaQiUscc:string, uscc:string, type:number, year:number, quarter:number ) {
    eccEnumValue("孵化器补充企业数据", "type", ENTERPRISEDECLARATIONTYPE, type);

    let dataInfo:any = {};
    if (type == ENTERPRISEDECLARATIONTYPE.团队信息) {
        dataInfo = await teamData.findTeamByUsccAndTime(uscc, year, quarter);
    } else {
        dataInfo = await businessData.findBusinessDataByTimeAndUscc(uscc, year, quarter);
    }
    
    if (dataInfo.fhqIsSubmit) throw new BizError(ERRORENUM.重复通过填报数据, `${fuHuaQiUscc} 企业审核 重复通过`);

    dataInfo.fhqIsSubmit = true;
    await dataInfo.save();

    return { isSuccess:true };
}


/**
 * 孵化器 回显 企业填报的团队信息 数据
 * @param fuHuaQiUscc 孵化器统一信用代码
 * @param uscc 企业统一信用代码
 * @param year 年度
 * @param quarter 季度
 * @returns 
 */
export async function selectFuHuaQiReplenishEnterpriseTeamData(fuHuaQiUscc:string,  uscc:string, year:number, quarter:number) {
    let teamInfo = await teamData.findTeamByUsccAndTime(uscc, year, quarter);
    let result = {
        doctor:teamInfo.doctor,//博士
        master:teamInfo.master,//硕士
        undergraduate:teamInfo.undergraduate,//本科
        juniorCollege:teamInfo.juniorCollege,//专科
        other:teamInfo.other,//其他
        studyAbroad:teamInfo.studyAbroad,//留学人数
        graduates:teamInfo.graduates,//应届毕业生

    }
    return result;
}


/**
 * 孵化器 回显 企业填报的经营 数据
 * @param fuHuaQiUscc 孵化器统一信用代码
 * @param uscc 企业统一信用代码
 * @param year 年度 
 * @param quarter 季度
 * @returns 
 */
export async function selectFuHuaQiReplenishEnterpriseBusinessData(fuHuaQiUscc:string,  uscc:string, year:number, quarter:number) {
    let businessInfo = await businessData.findBusinessDataByTimeAndUscc(uscc, year, quarter);
    
    let result = {
        BI:businessInfo.BI,//营业收入
        RD:businessInfo.RD,//研发投入
        TXP:businessInfo.TXP,//纳税
    }
    return result;

}
