/**
 * 重点企业
 */
import moment = require("moment");
import { ENTERPRISECHANGETYPE } from "../../../config/enum";
import * as dynamicsData from "../../../data/enterprise/dynamics";
import * as enterpriseData from "../../../data/enterprise/enterprise";
import * as labelData from "../../../data/label";
import { changeEnumValue } from "../../../util/verificationEnum";
import { LABELGOAL } from "../../../config/enum/labelEnum";
import { BizError } from "../../../util/bizError";
import { ERRORENUM } from "../../../config/errorEnum";


export async function keynoteDynamicsHomeList(fuHuaQiUscc:string) {
    let notRedCount = await dynamicsData.findCountByParam({fuHuaQiUscc, isRead:false});
    let dbList = await dynamicsData.findByParam({fuHuaQiUscc});

    let dataList = [];
    dbList.forEach(item => {
        let addInfo = {
            changeType:changeEnumValue(ENTERPRISECHANGETYPE, item.changeType),
            content:item.content,
            id:item.id,
            uscc:item.uscc
        };

        dataList.push(addInfo);
    });

    let followCount = await enterpriseData.findEnterpriseCount({fuHuaQiUscc, follow:true});


    return {dataList, notRedCount, followCount};
}


export async function keynoteDynamicsList(fuHuaQiUscc:string, type:number) {
    let param:any = {fuHuaQiUscc};

    if (type == 1) {
        param.isRead = true;
    } else {
        param.isRead = false;
    }

    let dbList = await dynamicsData.findByParam(param);

    let dataList = [];
    dbList.forEach(item => {
        let addInfo = {
            enterpriseName:item.enterpriseName,
            changeType:changeEnumValue(ENTERPRISECHANGETYPE, item.changeType),
            id:item.id,
            uscc:item.uscc,
            time:moment(item.createTime).format("YYYY-MM-DD")
        };

        dataList.push(addInfo);
    });


    return {dataList}
}

export async function changeReadState(id) {
    
    let dyInfo = await dynamicsData.findOne({id});

    if (!dyInfo || !dyInfo.id) return {isSuccess:true}
    dyInfo.isRead = true;

    await dyInfo.save();

    return {isSuccess:true}
}

export async function keynoteDynamicsEnterprise( uscc:string) {
    let etnerpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    if (!etnerpriseInfo || !etnerpriseInfo.uscc) {
        let dataList = [];
        return {dataList}
    }

    let dbList = await dynamicsData.findByParam({uscc});

    let enterpriseName = "";
    let dataList = [];
    dbList.forEach(item => {
        enterpriseName = item.enterpriseName;
        let addInfo = {
            changeType:changeEnumValue(ENTERPRISECHANGETYPE, item.changeType),
            oldContent:item.oldContent || "",
            newContent:item.content || "",
            time:moment().format("YYYY-MM-DD")
        };

        dataList.push(addInfo);
    });

    return {dataList, enterpriseName:etnerpriseInfo.name}
}


export async function keynoteList(fuHuaQiUscc:string, str:string, labels) {
    let param:any = {fuHuaQiUscc, follow:true};

    if (str) param.name = {"$regex":str}
    if (labels) param.labels =  {$elemMatch: { labelId: labels }}
    
    let dbList = await enterpriseData.findEnterpriseList(param);

    let labelMap = await labelData.getLabelNamMap(LABELGOAL.企业);

    let dynamicsList = await dynamicsData.findByParam({fuHuaQiUscc, isRead:false});
    let dynamicsMap = {};
    dynamicsList.forEach(item => {
        if (!dynamicsMap[item.uscc]) dynamicsMap[item.uscc] = 0;
        dynamicsMap[item.uscc] += 1;
    })

    let dataList = [];
    dbList.forEach(item => {
        let label = [];
        if (item.labels) {
            item.labels.forEach(labelItem => {
                if (labelItem.state && labelMap[labelItem.labelId]) {
                    label.push(labelMap[labelItem.labelId]);
                }
            })
        }
        dataList.push({
            enterpriseName:item.name,
            label,
            isFollow:item.follow== true,
            dynamicsCount:dynamicsMap[item.uscc] || 0,
            uscc:item.uscc
        });
    });

    return {dataList}
}

export async function changeEnterpriseFollow(uscc:string, followState) {

    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    if (!enterpriseInfo) throw new BizError(ERRORENUM.目标数据不存在);

    enterpriseInfo.follow = followState;
    await enterpriseInfo.save();

    return {isSuccess:true}
}