/**
 * 企业资质 相关逻辑
 * 作者：lxm
 */

import { EnterpriseQualificationUpdateConfig } from "../../../config//eccParam/enterprise";
import { LISTINGSITUATION } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { BizError } from "../../../util/bizError";
import { eccEnumValue } from "../../../util/verificationEnum";
import { eccFormParam } from "../../../util/verificationParam";
import * as enterpriseData from "../../../data/enterprise/enterprise";
import { addEnterprisePoint } from "../../point";
import { ENTERPRISENODEENUM } from "../../../config/pointConfig";
import { enterpriseLabelEvent } from "../../label";
import { LABELEVENT } from "../../../config/enum/labelEnum";



/**
 * 获取企业资质信息
 * @param uscc 企业统一信用代码
 * @returns 
 */
export async function selectQualification(uscc:string) {
    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);

    let defaultQualification = {
        isHighTech:false,//是否是高新技术企业
        highTechMs:0,//高新技术认证时间戳
        isZjtx:false,//是否专精特新企业
        zjtxMs:0,//专精特新认证时间戳
        isXjrpy:false,//是否小巨人培育企业
        xjrpyMs:0,//小巨人培育企业时间戳
        isXjr:false,//是否是小巨人企业
        xjrMs:0,//小巨人企业认证时间
        beOnTheMarket:[],//上市情况
        isBeOnTheMarket:false
    };
    
    return enterpriseInfo.qualification || defaultQualification;
}


/**
 * 修改企业资质
 * @param uscc 企业统一信用代码
 * @returns 
 */
export async function updateQualification(uscc:string, param) {
    eccFormParam("修改企业资质", EnterpriseQualificationUpdateConfig, param);

    if (param.isBeOnTheMarket) {
        if (!param.beOnTheMarket.length) throw new BizError(ERRORENUM.参数错误, '修改企业资质', '缺失 beOnTheMarket  ')
        eccEnumValue("修改企业资质", "beOnTheMarket", LISTINGSITUATION, param.beOnTheMarket );
    } else param.beOnTheMarket = [];

    let enterpriseInfo = await enterpriseData.findEnterpriseByUscc(uscc);

    /**埋点 */
    let oldQualification = enterpriseInfo.qualification || {};

    let oldHighTechData = {highTechMs:oldQualification.highTechMs, isHighTech:oldQualification.isHighTech};
    let newHighTechData = {highTechMs:param.highTechMs, isHighTech:param.isHighTech};
    addEnterprisePoint( uscc, ENTERPRISENODEENUM.企业资质_高新技术,oldHighTechData, newHighTechData );

    let oldIsZjtxData = {isZjtx:oldQualification.isZjtx, zjtxMs:oldQualification.zjtxMs};
    let newIsZjtxData = {isZjtx:param.isZjtx, zjtxMs:param.zjtxMs};
    addEnterprisePoint( uscc, ENTERPRISENODEENUM.企业资质_专精特新,oldIsZjtxData, newIsZjtxData );

    let oldIsXjrpyData = {isXjrpy:oldQualification.isXjrpy, xjrpyMs:oldQualification.xjrpyMs};
    let newIsXjrpyData = {isXjrpy:param.isXjrpy, xjrpyMs:param.xjrpyMs};
    addEnterprisePoint( uscc, ENTERPRISENODEENUM.企业资质_小巨人培育,oldIsXjrpyData, newIsXjrpyData );

    let oldIsXjrData = {isXjr:oldQualification.isXjr, xjrMs:oldQualification.xjrMs};
    let newIsXjrData = {isXjr:param.isXjr, xjrMs:param.xjrMs};
    addEnterprisePoint( uscc, ENTERPRISENODEENUM.企业资质_小巨人,oldIsXjrData, newIsXjrData );

    let oldMarketData = {
        beOnTheMarket:oldQualification.beOnTheMarket ? JSON.stringify(oldQualification.beOnTheMarket) : '[]', 
        isBeOnTheMarket:oldQualification.isBeOnTheMarket
    };
    let newMarketData = {
        beOnTheMarket:param.beOnTheMarket ? JSON.stringify(param.beOnTheMarket) : '[]', 
        isBeOnTheMarket:param.isBeOnTheMarket
    };
    addEnterprisePoint(uscc, ENTERPRISENODEENUM.企业资质_上市情况,oldMarketData, newMarketData );
    
    enterpriseInfo.qualification = JSON.parse(JSON.stringify(param) );

    /**标签 */
    await enterpriseLabelEvent(enterpriseInfo, LABELEVENT.资质更新, '企业登记');

    /**修改了之后去掉 红框提示 */
    if (!enterpriseInfo.tipsQualification ) {
        enterpriseInfo.tipsQualification = true;
    }

    await enterpriseInfo.save();
    
    return {isSuccess:true};
}
