//企业端 活动
import moment = require("moment");
import * as activityData from "../../data/activity";
import { changeEnumManyValue } from "../../util/verificationEnum";
import { ACTIVITYLABEL } from "../../config/enum";

export async function activityList() {
    let dbList = await activityData.findByParam({});

    let dataList = [];
    dbList.forEach(info => {
        let {address, title, img, startTime, endTime, id, labelList} = info;
        labelList = labelList || [];
        let label = [];
        labelList.forEach(labelInfo => {
            label.push({
                key:ACTIVITYLABEL[labelInfo],
                value:labelInfo
            });
        })
        
        dataList.push({
            label,
            address, title, img, id,time:`${moment(startTime).format("YYYY/MM/DD")}-${moment(endTime).format("YYYY/MM/DD")}`
        });
    });

    return {dataList};
}




export async function activityInfo(id) {
    let activityInfo = await activityData.findOne({id});

    let dataInfo = {
        title:activityInfo.activityInfo,//标题
        content:activityInfo.activityInfo,//内容
        img:activityInfo.activityInfo,//图片
        source:activityInfo.source,//来源
        createTime:activityInfo.createTime,//创建时间
    };

    return {dataInfo}
}