/**
 * 标签系统 主要逻辑
 */
import { FUHUASTATE, INDUSTRY,  MOVEOUTTYPE, STATEENUM } from "../config/enum";
import { findEnterpriseByUscc, findUsccList } from "../data/enterprise/enterprise";
import * as fuHuaQiLabelLogData from "../data/fuHuaQi/fuHuaQiLabelLog";
import * as enterpriseLabelLogData from "../data/enterprise/enterpriseLabelLog";
import { findFuHuaQiByUSCC, findFuHuaQiOperationNameMapByParam } from "../data/fuHuaQi/fuhuaqi";
import { selectEnterpriseFinancingAmount } from "../data/enterprise/financingInfo";
import { selectEnterpriseBusinessAmount } from "../data/enterprise/quarterTask/businessdata";
import { addSystemLabel, findOnceLabel } from "../data/label";
import { changeAddToString, getLabelId } from "../tools/system";
import { addressIsInZJ } from "../tools/transCode";
import moment = require("moment");
import { ENTERPRISESYSTEMLABEL, LABELEVENT, LABELGOAL, LABELTYPE, LABELUPDATEROAD, FHQSYSTEMLABEL } from "../config/enum/labelEnum";

/**企业标签操作 */

/**
 * 【企业标签】添加单个
 * @param uscc 
 * @param labelId 
 */
export async function inLabelToEnterprise(enterpriseInfo, labelId:string, p1?) {
    let desc = p1 || '';
    let labelItem = {labelId, state:true};

    if (!enterpriseInfo.labels) enterpriseInfo.labels = [labelItem];
    else {
        let checkIndex = -1;
        enterpriseInfo.labels.forEach((info, index) => {
            if (info.labelId == labelId) checkIndex = index;
        });
        if (checkIndex != -1 ) {
            enterpriseInfo.labels[checkIndex].state = true;
            await enterpriseLabelLogData.addOnceLabelLog(enterpriseInfo.uscc, labelId, LABELUPDATEROAD.重新生效, desc);
        } else {
            enterpriseInfo.labels.push(labelItem);
            await enterpriseLabelLogData.addOnceLabelLog(enterpriseInfo.uscc, labelId, LABELUPDATEROAD.失效, desc);
        }
    }
}



/**
 * 【企业标签】修改 使用的时候
 * @param uscc 
 * @param labelIdList 
 */
export async function updateLabelToEnterprise(uscc:string, labelIdList, p1?) {
    let desc = p1 || '';
    let enterpriseInfo = await findEnterpriseByUscc(uscc);
    if (!enterpriseInfo.labels) enterpriseInfo.labels = [];

    /**遍历老的 */
    let oldMap = {};
    let delList = [];//删除的标签
    enterpriseInfo.labels.forEach((info, index) => {
        let {labelId, state} = info;
        oldMap[labelId] = {labelId, state, index};
        if (labelIdList.indexOf(labelId) == -1) {
            delList.push({labelId, index});
        }
    });

    let ct = new Date().valueOf();
    let logList = [];
    labelIdList.forEach(labelId => {
        if (!oldMap[labelId]) {
            enterpriseInfo.labels.push({labelId, state:true});
            logList.push({uscc, labelId, desc, road:LABELUPDATEROAD.生效, ct});
        } else if (!oldMap[labelId].state) {
            let {index} = oldMap[labelId];
            enterpriseInfo.labels[index].state = true;
            logList.push({uscc, labelId, desc, road:LABELUPDATEROAD.重新生效, ct});
        }
    });

    delList.forEach(info => {
        let {index, labelId} = info;
        enterpriseInfo.labels[index].state = false;
        logList.push({uscc, labelId, desc, road:LABELUPDATEROAD.失效, ct});
    });

    await enterpriseInfo.save();

    if (logList.length) await enterpriseLabelLogData.addManyLabelLog(logList);
}

/**
 * 【企业标签】失效
 * 失效标签不会新增
 * @param uscc 
 * @param labelId 
 */
export async function outLabelToEnterprise(enterpriseInfo, labelId:string, p1?) {
    let desc = p1 || '';
    let checkIndex = -1;
    enterpriseInfo.labels.forEach((info, index) => {
        if (info.labelId == labelId) checkIndex = index;
    });
    if (checkIndex != -1 ) {
        enterpriseInfo.labels[checkIndex].state = false;
        await enterpriseLabelLogData.addOnceLabelLog(enterpriseInfo.uscc, labelId, LABELUPDATEROAD.失效, desc);
    }

}


/**孵化器标签操作 */

/**
 * 【孵化器标签】添加单个  
 * @param uscc 
 * @param labelId 
 */
export async function inOnceLabelToFuHuaQi(fuHuaQiInfo:any, labelId:string, p1?) {
    let desc = p1 || '';
    let labelItem = {labelId, state:true};

    if (!fuHuaQiInfo.labels) fuHuaQiInfo.labels = [labelItem];
    else {
        let checkIndex = -1;
        fuHuaQiInfo.labels.forEach((info, index) => {
            if (info.labelId == labelId) checkIndex = index;
        });
        if (checkIndex != -1 ) {
            fuHuaQiInfo.labels[checkIndex].state = true;
            await fuHuaQiLabelLogData.addOnceLabelLog(fuHuaQiInfo.uscc, labelId, LABELUPDATEROAD.重新生效, desc);
        } else {
            fuHuaQiInfo.labels.push(labelItem);
            await fuHuaQiLabelLogData.addOnceLabelLog(fuHuaQiInfo.uscc, labelId, LABELUPDATEROAD.生效, desc);
        }
    }
   
}


/**
 * 【孵化器标签】修改  使用的时候，不能被.save()方法嵌套
 * @param uscc 
 * @param labelIdList 
 */
export async function updateLabelToFuHuaQi(uscc:string, labelIdList, p1?) {
    let desc = p1 || '';
    let fuHuaQiInfo = await findFuHuaQiByUSCC(uscc);
    if (!fuHuaQiInfo.labels) fuHuaQiInfo.labels = [];

    /**遍历老的 */
    let oldMap = {};
    let delList = [];//删除的标签
    fuHuaQiInfo.labels.forEach((info, index) => {
        let {labelId, state} = info;
        oldMap[labelId] = {labelId, state, index};
        if (labelIdList.indexOf(labelId) == -1) {
            delList.push({labelId, index});
        }
    });

    let ct = new Date().valueOf();
    let logList = [];
    labelIdList.forEach(labelId => {
        if (!oldMap[labelId]) {
            fuHuaQiInfo.labels.push({labelId, state:true});
            logList.push({uscc, labelId, desc, road:LABELUPDATEROAD.生效, ct});
        } else if (!oldMap[labelId].state) {
            let {index} = oldMap[labelId];
            fuHuaQiInfo.labels[index].state = true;
            logList.push({uscc, labelId, desc, road:LABELUPDATEROAD.重新生效, ct});
        }
    });

    delList.forEach(info => {
        let {index, labelId} = info;
        fuHuaQiInfo.labels[index].state = false;
        logList.push({uscc, labelId, desc, road:LABELUPDATEROAD.失效, ct});
    });

    await fuHuaQiInfo.save();

    if (logList.length) await fuHuaQiLabelLogData.addManyLabelLog(logList);
}



/**
 * 【孵化器标签】失效
 * @param uscc 
 * @param labelId 
 */
export async function outLabelToFuHuaQi(fuHuaQiInfo:any, labelId:string, p1?) {
    let desc = p1 || '';
    let checkIndex = -1;
    if (!fuHuaQiInfo.labels) fuHuaQiInfo.labels = [];
    fuHuaQiInfo.labels.forEach((info, index) => {
        if (info.labelId == labelId) checkIndex = index;
    });
    if (checkIndex != -1 ) {
        fuHuaQiInfo.labels[checkIndex].state = false;
        await fuHuaQiLabelLogData.addOnceLabelLog(fuHuaQiInfo.uscc, labelId, LABELUPDATEROAD.失效, desc);
        await fuHuaQiInfo.save();
    }

}


/**防止 百度api接口触发 100/s 接口限制 */
function sleep() {
    return new Promise((resolve, reject) => {
        setTimeout(()=> {
            resolve({});
        }, 12);
    });
}

/**
 * 系统标签【被动标签】 初始化
 * 即：需要系统通过其他条件（时间条件）等判断的
 */
export async function systemLabel() {
    /**在孵化企业 */
    let usccList = await findUsccList();
    let fuHuaQiNameMap = await findFuHuaQiOperationNameMapByParam({});
    let addLogList = [];
    let successCount = 0;
    let allCount = usccList.length;
    for (let i = 0; i < usccList.length; i++) {
        let {uscc} = usccList[i];
        let enterpriseInfo = await findEnterpriseByUscc(uscc);
        let industry = enterpriseInfo.industry || [];
        let logonTime = enterpriseInfo.logonTime;
        let logonAddress = enterpriseInfo.logonAddress;
        let fuHuaState = enterpriseInfo.state;//孵化状态
        let fuHuaQiName = fuHuaQiNameMap[enterpriseInfo.fuHuaQiUscc];
        let zaiFuQiYeSuccess = false;//在孵企业时间符合规则
        let logonAddressSuccess = false;//注册地址符合规则
        let  shiRuZhuFeiFu = false;//是入驻非孵企业
        if (logonTime) {
            let yearLong = moment().diff(logonTime, 'years');
            if (industry.indexOf(INDUSTRY.人工智能及智能制造) != -1 || industry.indexOf(INDUSTRY.生物医药) != -1 || industry.indexOf(INDUSTRY.集成电路) != -1) {
                if (yearLong < 5) zaiFuQiYeSuccess = true;
                else shiRuZhuFeiFu = true;
            } else {//其他领域
                if (yearLong < 4) zaiFuQiYeSuccess = true;
                else shiRuZhuFeiFu = true;
            }
        }
        if (logonAddress && fuHuaState == FUHUASTATE.实体孵化) {
            let isInZJ = await addressIsInZJ(changeAddToString(logonAddress));
            if (isInZJ) {
                logonAddressSuccess = true;
            }
        }

        let shiZaiFuQiYe = zaiFuQiYeSuccess && logonAddressSuccess && fuHuaState == FUHUASTATE.实体孵化;//是在孵企业

        let qiYeRongZiDaBiao = await selectEnterpriseFinancingAmount(uscc);//企业融资达标
        let yingYeShouRuDaBiao = await selectEnterpriseBusinessAmount(uscc);//营业收入达标

        let ct = new Date().valueOf();

        if (enterpriseInfo.labels && enterpriseInfo.labels.length) {//原本存在标签，需要进行筛选
            let checkMap = {};
            enterpriseInfo.labels.forEach((info, index) => {
                let {labelId, state} = info; 
                if (labelId == ENTERPRISESYSTEMLABEL.在孵企业 || labelId == ENTERPRISESYSTEMLABEL.入驻非孵 || labelId == ENTERPRISESYSTEMLABEL.拟毕业企业){
                    checkMap[labelId] = {labelId, state, index};
                }
            });

            let mingZhongZaiFuQiYe = checkMap[ENTERPRISESYSTEMLABEL.在孵企业];//命中在孵企业
            if (!mingZhongZaiFuQiYe) {//未命中，证明原本没有这个标签
                //未命中情况下 只需要考虑生效标签
                if (shiZaiFuQiYe){
                    enterpriseInfo.labels.push({labelId:ENTERPRISESYSTEMLABEL.在孵企业, state:true});
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.在孵企业, desc:`${fuHuaQiName}`, road:LABELUPDATEROAD.生效, ct});
                }
            } else {//原本列表已存在这个标签
                if (shiZaiFuQiYe && !mingZhongZaiFuQiYe.state) {
                    //现在属于在孵企业  且  原本为失效
                    enterpriseInfo.labels[mingZhongZaiFuQiYe.index].state = true;
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.在孵企业, desc:`${fuHuaQiName}`, road:LABELUPDATEROAD.重新生效, ct});
                }
                if (!shiZaiFuQiYe && mingZhongZaiFuQiYe.state) {
                    //不属于在孵企业 且原本为生效
                    enterpriseInfo.labels[mingZhongZaiFuQiYe.index].state = false;
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.在孵企业, desc:``, road:LABELUPDATEROAD.失效, ct});
                }
            }

            let mingZhongRuZhuFeiFu = checkMap[ENTERPRISESYSTEMLABEL.入驻非孵];//命中入驻非孵
            if (!mingZhongRuZhuFeiFu) {//未命中，证明原本没有这个标签
                //未命中情况下 只需要考虑生效标签
                if (shiRuZhuFeiFu) {
                    enterpriseInfo.labels.push({labelId:ENTERPRISESYSTEMLABEL.入驻非孵, state:true});
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.入驻非孵, desc:``, road:LABELUPDATEROAD.生效, ct});
                }

            } else {
                //原本列表已存在这个标签
                if (shiRuZhuFeiFu && !mingZhongRuZhuFeiFu.state) {
                    //属于入驻非孵企业  且原本为失效
                    enterpriseInfo.labels[mingZhongRuZhuFeiFu.index].state = true;
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.入驻非孵, desc:``, road:LABELUPDATEROAD.重新生效, ct});
                }
                if (!shiRuZhuFeiFu && mingZhongRuZhuFeiFu.state && fuHuaState == FUHUASTATE.迁出) {//企业迁出久失效
                    //不属于入驻非孵企业 且原本为生效 且  企业迁出
                    enterpriseInfo.labels[mingZhongRuZhuFeiFu.index].state = false;
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.入驻非孵, desc:``, road:LABELUPDATEROAD.失效, ct});
                }
            }

            /**判断已有的标签里有无生效的 拟毕业 依据条件 */
            let manZuBiaoQianYiJu = false;//满足标签依据
            if ( (checkMap[ENTERPRISESYSTEMLABEL.高新企业] && checkMap[ENTERPRISESYSTEMLABEL.高新企业].state) ||
                (checkMap[ENTERPRISESYSTEMLABEL.小巨人] && checkMap[ENTERPRISESYSTEMLABEL.小巨人].state) ||
                (checkMap[ENTERPRISESYSTEMLABEL.专精特新] && checkMap[ENTERPRISESYSTEMLABEL.专精特新].state) ||
                (checkMap[ENTERPRISESYSTEMLABEL.上市企业] && checkMap[ENTERPRISESYSTEMLABEL.上市企业].state)
            ) {
                manZuBiaoQianYiJu = true;
            }
            let mingZhongNiBiYeQiYe = checkMap[ENTERPRISESYSTEMLABEL.拟毕业企业];//命中拟毕业企业
            if (qiYeRongZiDaBiao || yingYeShouRuDaBiao || manZuBiaoQianYiJu) {
                if (!mingZhongNiBiYeQiYe) {
                    enterpriseInfo.labels.push({labelId:ENTERPRISESYSTEMLABEL.拟毕业企业, state:true});
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.拟毕业企业, desc:``, road:LABELUPDATEROAD.生效, ct});
                } else if (!mingZhongNiBiYeQiYe.state) {
                    enterpriseInfo.labels[mingZhongNiBiYeQiYe.index].state = true;
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.拟毕业企业, desc:``, road:LABELUPDATEROAD.重新生效, ct});
                }
            } else {//失效
                if(mingZhongNiBiYeQiYe && mingZhongNiBiYeQiYe.state) {
                    enterpriseInfo.labels[mingZhongNiBiYeQiYe.index].state = false;
                    addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.拟毕业企业, desc:``, road:LABELUPDATEROAD.失效, ct});
                }
            }

           
        } else {
            enterpriseInfo.labels = [];
            if (shiZaiFuQiYe) {
                enterpriseInfo.labels.push({labelId:ENTERPRISESYSTEMLABEL.在孵企业, state:true});
                addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.在孵企业, desc:`${fuHuaQiName}`, road:LABELUPDATEROAD.生效, ct});
            } else if (shiRuZhuFeiFu) {
                enterpriseInfo.labels.push({labelId:ENTERPRISESYSTEMLABEL.入驻非孵, state:true});
                addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.入驻非孵, desc:``, road:LABELUPDATEROAD.生效, ct});
            }

            if (qiYeRongZiDaBiao || yingYeShouRuDaBiao) {
                enterpriseInfo.labels.push({labelId:ENTERPRISESYSTEMLABEL.拟毕业企业, state:true});
                addLogList.push({uscc, labelId:ENTERPRISESYSTEMLABEL.拟毕业企业, desc:``, road:LABELUPDATEROAD.生效, ct});
            }

        }
        
        await enterpriseInfo.save();

        await sleep();
        successCount += 1;
        if (i%100 == 0) {
            console.log("进度：", Math.ceil((successCount/allCount)*10000)/100,'%');
        }
    }

    //添加日志
    if (addLogList.length) {
        await enterpriseLabelLogData.addManyLabelLog(addLogList);
    }
}


/**
 * 初始化系统标签 包括 孵化器系统标签和企业系统标签
 * @returns 
 */
export async function initSystemLabelData() {
    let labelInfo = await findOnceLabel(ENTERPRISESYSTEMLABEL.在孵企业);
    if (labelInfo && labelInfo.id) {
        return;
    }
    let now = new Date().valueOf();

    let systemLabelList = [];
    systemLabelList.push({id:'zfqy', labelName:"在孵企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'byqy', labelName:"毕业企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'nbyqy', labelName:"拟毕业企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'rzqy', labelName:"融资企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'ssqy', labelName:"上市企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'gxqy', labelName:"高新企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'zjtxqy', labelName:"专精特新", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'xjrqy', labelName:"小巨人", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'rzffqy', labelName:"入驻非孵", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'xnqy', labelName:"虚拟企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'qcqy', labelName:"迁出企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:'qyzx', labelName:"企业注销", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.系统标签, state:false});

    systemLabelList.push({id:getLabelId(), labelName:"上市企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.自定义标签, state:false});
    systemLabelList.push({id:getLabelId(), labelName:"高新企业", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.自定义标签, state:false});
    systemLabelList.push({id:getLabelId(), labelName:"专精特新", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.自定义标签, state:false});
    systemLabelList.push({id:getLabelId(), labelName:"小巨人", ctMs:now, goal:LABELGOAL.企业, labelType:LABELTYPE.自定义标签, state:false});

    systemLabelList.push({id:'fhqzyjspt', labelName:"专业技术平台", ctMs:now, goal:LABELGOAL.孵化器, labelType:LABELTYPE.系统标签, state:false});
    systemLabelList.push({id:getLabelId(), labelName:"高质量孵化", ctMs:now, goal:LABELGOAL.孵化器, labelType:LABELTYPE.自定义标签, state:false});
    systemLabelList.push({id:getLabelId(), labelName:"高质量培育", ctMs:now, goal:LABELGOAL.孵化器, labelType:LABELTYPE.自定义标签, state:false});
    systemLabelList.push({id:getLabelId(), labelName:"加速器", ctMs:now, goal:LABELGOAL.孵化器, labelType:LABELTYPE.自定义标签, state:false});

    addSystemLabel(systemLabelList);
}

/**
 * 企业事件标签，事件触标签
 * 需要注意，传入的企业对象必须是必要条件修改之后的对象
 * @param enterpriseInfo 
 * @param labelEventPoint 
 * @param p1 
 */
export async function enterpriseLabelEvent(enterpriseInfo, labelEventPoint, p1?, p2?) {
    switch (labelEventPoint) {
        case LABELEVENT.入孵:
            /**入孵企业判断是不是在孵化企业标签 并且将其他标签失效*/
            /**p1 = 传入孵化器名称 */
            let isZfqy= false;
            let logonAddressStr = changeAddToString(enterpriseInfo.logonAddress);
            if (logonAddressStr && enterpriseInfo.state == FUHUASTATE.实体孵化 && enterpriseInfo.logonTime && enterpriseInfo.industry) {
                let yearLong = moment().diff(enterpriseInfo.logonTime, 'years');
                if ([INDUSTRY.人工智能及智能制造, INDUSTRY.生物医药, INDUSTRY.集成电路].every(e => enterpriseInfo.industry.includes(e))) {
                    if (yearLong < 5) isZfqy = true;
                    else isZfqy = true;
                } else {
                    if (yearLong < 4) isZfqy = true;
                    else isZfqy = true;
                }
                isZfqy = await addressIsInZJ(logonAddressStr);
            }
            if (isZfqy) {
                inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.在孵企业, p1);
            }
            //如果存在迁出相关标签
            if (enterpriseInfo.labels) {
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.企业注销);
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.迁出企业);
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.毕业企业);
                //兼容老数据  虚拟企业变成=>实体孵化  这个if理论上不会执行
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.虚拟企业);
            }
        break;
        case LABELEVENT.迁出:
            /**迁出企业需要 置灰在孵企业标签 拟毕业等 */
            /**p1 = 传入孵化器名称 */
            if (enterpriseInfo.state == FUHUASTATE.迁出) {
                if (enterpriseInfo.moveOutType == MOVEOUTTYPE.企业注销) {
                    inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.企业注销);
                } else {
                    let outStr = "非毕业迁出";
                    if (enterpriseInfo.moveOutType == MOVEOUTTYPE.毕业迁出) {
                        inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.毕业企业, p1);
                        outStr = "毕业迁出";
                    }
                    inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.迁出企业, outStr);
                }
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.在孵企业);
            }
        break;
        case LABELEVENT.融资:
            /**p1 = 融资轮次， p2 = 融资金额*/
            inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.融资企业, `获得${p1}融资，${p2}万元`);
        break;
        case LABELEVENT.资质更新:
            /** 更新企业资质标签 触发拟毕业 */
            /**p1 = '企业登记' */
            p1 = p1 || '';
            if (enterpriseInfo.qualification) {
                if (enterpriseInfo.qualification.isBeOnTheMarket) {
                    inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.上市企业, p1);
                } else {
                    outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.上市企业);
                }

                if (enterpriseInfo.qualification.isZjtx) {
                    inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.专精特新, p1);
                } else {
                    outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.专精特新);
                }

                if (enterpriseInfo.qualification.xjrMs) {
                    inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.小巨人, p1);
                } else {
                    outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.小巨人);
                }

                if (enterpriseInfo.qualification.isHighTech) {
                    inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.高新企业, p1);
                } else {
                    outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.高新企业);
                }


            }
           
        break;
        case LABELEVENT.孵化类型更新:
            /**实体->虚拟 需要将入孵企业标签失效 */
            /**p1 = 孵化器名称 */
            if (enterpriseInfo.state == FUHUASTATE.虚拟孵化) {
                inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.虚拟企业, p1);
            } else {
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.虚拟企业);
                let isZfqy= false;
                let logonAddressStr = changeAddToString(enterpriseInfo.logonAddress);
                if (logonAddressStr && enterpriseInfo.state == FUHUASTATE.实体孵化 && enterpriseInfo.logonTime && enterpriseInfo.industry) {
                    let yearLong = moment().diff(enterpriseInfo.logonTime, 'years');
                    if ([INDUSTRY.人工智能及智能制造, INDUSTRY.生物医药, INDUSTRY.集成电路].every(e => enterpriseInfo.industry.includes(e))) {
                        if (yearLong < 5) isZfqy = true;
                        else isZfqy = true;
                    } else {
                        if (yearLong < 4) isZfqy = true;
                        else isZfqy = true;
                    }
                    isZfqy = await addressIsInZJ(logonAddressStr);
                }
                if (isZfqy) {
                    inLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.在孵企业, p1);
                }
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.企业注销);
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.迁出企业);
                outLabelToEnterprise(enterpriseInfo, ENTERPRISESYSTEMLABEL.毕业企业);
            }
        break;
    }
}


/**
 * 孵化器事件标签
 * @param fuHuaQiInfo 
 * @param labelId 
 * @param p1 
 */
export function fuHuaQiEventLabel(fuHuaQiInfo, labelId, p1?) {
    switch (labelId) {
        case FHQSYSTEMLABEL.专业技术平台: 
            if (fuHuaQiInfo.isProfessionalTechnology == STATEENUM.是) {
                inOnceLabelToFuHuaQi(fuHuaQiInfo, labelId, p1);
            } else {
                outLabelToFuHuaQi(fuHuaQiInfo, labelId, p1);
            }
        break;
        
    }

}