

import * as sysTools from "../tools/system";
import * as enterpriseData from "../data/enterprise/enterprise";


/**
 * 修改企业密码为统一信用代码后六位
 * @param uscc 企业统一信用代码
 */
export async function enterpriseChangePwd(uscc:string) {
    let dataBaseInfo = await enterpriseData.findEnterpriseByUscc(uscc);
    let pwd = uscc.slice(-6);
    console.log(`已初始化企业：${uscc}, 密码：${pwd}`);
    dataBaseInfo.pwd = sysTools.getPwdMd5(uscc, sysTools.md5PwdStr(pwd));
    await dataBaseInfo.save();

    return {isSuccess:true};
}


/**
 * 匹配上海张江药谷公共服务平台有限公司
 */
export async function getFuHuaQiEnterprise() {
    let dataBaseInfo = await enterpriseData.findEnterpriseList({"fuHuaQiUscc": "913101157664917120", "state":{"$ne":4 }}); //上海张江药谷公共服务平台有限公司
    console.log(dataBaseInfo.length);
    for (let i = 0; i < dataBaseInfo.length; i++) {
        let enterpriseInfo = dataBaseInfo[i];
        await enterpriseChangePwd(enterpriseInfo.uscc);
        console.log();
    }

    return {isSuccess:true};
}


