/**
 * 数据同步
 */

import { TASKTYPEENUM } from "../config/enum";
import { findEnterpriseByUscc } from "../data/enterprise/enterprise";
import { eccFormParam } from "../util/verificationParam";
import { registerEnterprise } from "./mobileFuHuaQi/enterprise/enterprise";
import { createReport, updateReport } from "./mobileFuHuaQi/fuHuaQi/month";
import { checkTask } from "./mobileFuHuaQi/fuHuaQi/task/monthTask";


/**
 * 同步新注册企业
 */
export async function syncMonthTask(enterpriseList, rate) {

    const EnterpriseConfig = {
        name:{type:"String"}, //企业名称
        uscc:{type:"String"}, //统一信用代码
        industry:{type:"[Number]"},//领域
        logonTime:{type:"Number"},//注册时间
        firstIncubationTime:{type:"Number"},//首次入孵时间
        isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
        logonAddress:{type:"Address"},//注册地址 2.1修改
        operatingAddress:{type:"Address"},//经营地址 2.1修改
        leasedArea:{type:"Number"},//租赁面积（平方米）
        mainBusiness:{type:"String"},//主营业务
        jiaSu:{type:"Number"},//加速企业 是=1 否 =2
        jiaSuZiZhi:{type:"[Number]",  notMustHave:true},//加速资质
        jiaSuZiZhiDesc:{type:"String",  notMustHave:true},//加速资质其他
        leaseAddress:{type:"String"},//租赁地址
        price:{type:"Number"},//单价
        contractStartTime:{type:"Number"},//合同开始时间
        contractEndTime:{type:"Number"},//合同结束时间
        payStartTime:{type:"Number"},//租金缴纳时间
        payLong:{type:"Number"},//缴纳时长
        areaUnit:{type:"Number"},
    };

    let dataList = [];
    //先校验数据
    enterpriseList.forEach(info => {
        let eccResult = eccFormParam("校验同步数据时的新注册企业", EnterpriseConfig, info);
        if (eccResult) {
            dataList.push(info);
        }

    });

    for (let i=  0; i < dataList.length; i++) {

       
        let item = dataList[i];
        let info = await findEnterpriseByUscc(item.uscc);
        if (!info || !info.uscc) {
            await registerEnterprise("91310115069312504K", item);
        }
        
    }

    await createReport("91310115069312504K", rate);

    return {isSuccess:true}
}


export async function asyncCheckTask() {
    await checkTask("91310115069312504K", TASKTYPEENUM.孵化器月度填报);
    await checkTask("91310115069312504K", TASKTYPEENUM.新注册或迁入企业登记);
    await checkTask("91310115069312504K", TASKTYPEENUM.融资企业填报);
    console.log("任务自动提交成功");
    return {isSuccess:true}
}

/**
 * 同步迁入企业数据
 */
export async function aysncMoveInEnterprsieData() {

}


/**
 * 同步融资数据
 */
export async function asyncFinancingData() {

}


/**
 * 同步出租率
 */
export async function asyncRateData() {

}