/**
 * 管理后台 任务中心相关逻辑
 */

import { OUTPUTTYPE, TASKTYPEENUM } from "../../../config/enum";
import * as taskData from "../../../data/fuHuaQi/monthTask/task";
import * as fuhuaqiData from "../../../data/fuHuaQi/fuhuaqi";
import { BizError } from "../../../util/bizError";
import { ERRORENUM } from "../../../config/errorEnum";
import { findBusinessDataByParam, findBusinessDataByParamToPage, findBusinessDataCountByParam } from "../../../data/fuHuaQi/quarterTask/businessData";


/**
 * 融资企业填报任务 列表
 * @param upState 填报状态
 * @param time 日期
 * @param page 页数
 */
export async function financingTaskList(state:number, time:number, page:number) {
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);
    let selectParam:any= {type:TASKTYPEENUM.融资企业填报};
    if (state > 1) {
        selectParam.isSubmit = state == 2 ? true : false;
    }
    if (time) {
        selectParam.year = new Date(time).getFullYear();
        selectParam.month = new Date(time).getMonth() + 1;
    }
    let nameMap = await fuhuaqiData.findFuHuaQiOperationNameMapByParam({});
    
 
    let taskList = await taskData.findTaskListByParamAndPage(selectParam, (page -1)*10);

    let reslutList = [];
    taskList.forEach(info => {
        let {submitCount, fuHuaQiUscc, month, year, isSubmit } = info;
        let item = {
            name : nameMap[fuHuaQiUscc],
            addCount:submitCount,
            dataTime:`${year}年${month}`,
            state:isSubmit? "已填报": "未填报"
        };
        reslutList.push(item);
    });

    let count = await taskData.findTaskCountByParamCount(selectParam);
    let pageCount = Math.ceil(count/10);

    return {count, dataList:reslutList, pageCount};
}


/**
 * 导出融资企业填报任务 列表
 * @param upState 填报状态
 * @param time 日期
 * @param type 查询类型
 */
export async function outPutFinancingTaskList(state:number, time:number, type:number) {
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);
    
    let selectParam:any= {type:TASKTYPEENUM.融资企业填报};

    let name = "全部";

    if (type == OUTPUTTYPE.当前数据 ) {
        if (state == 2 || state == 3) {
            selectParam.draftLock = state == 2 ? true : false;
        }
        if (time) {
            selectParam.year = new Date(time).getFullYear();
            selectParam.month = new Date(time).getMonth() + 1;
            name = `${selectParam.year}年${selectParam.month}月`;
        }
        name = "当前";
    }

    let nameMap = await fuhuaqiData.findFuHuaQiOperationNameMapByParam({});
    
    let taskList = await taskData.findTaskListByParam(selectParam);

    let dataList = [["运营机构名称", "填报状态", "数据月份", "本月新增数量"]];
    taskList.forEach(info => {
        let {submitCount, fuHuaQiUscc, month, year, isSubmit } = info;
        let name = nameMap[fuHuaQiUscc];
        let state = isSubmit? "已填报": "未填报" ;
        let dataTime = `${year}年${month}`;

        dataList.push([name, state, dataTime, submitCount]);
    });

    

    return { dataList, name };
}


/**
 * 新增企业任务 列表
 * @param upState 填报状态
 * @param time 日期
 */
export async function addEnterpriseTaskList(state:number, time:number, page:number) {
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);
    let selectParam:any= {type:TASKTYPEENUM.新注册或迁入企业登记};
    if (state>1) {
        selectParam.isSubmit = state == 2 ? true : false;
    }
    if (time) {
        selectParam.year = new Date(time).getFullYear();
        selectParam.month = new Date(time).getMonth() + 1;
    }
    let nameMap = await fuhuaqiData.findFuHuaQiOperationNameMapByParam({});
    
 
    let taskList = await taskData.findTaskListByParamAndPage(selectParam, (page -1)*10);

    let reslutList = [];
    taskList.forEach(info => {
        let {submitCount, fuHuaQiUscc, month, year, isSubmit } = info;
        let item = {
            name : nameMap[fuHuaQiUscc],
            addCount:submitCount,
            dataTime:`${year}年${month}`,
            state:isSubmit? "已填报": "未填报"
        };
        reslutList.push(item);
    });

    let count = await taskData.findTaskCountByParamCount(selectParam);
    let pageCount = Math.ceil(count/10);

    return {count, dataList:reslutList, pageCount};
}


/**
 * 导出新增企业任务 列表
 * @param upState 填报状态
 * @param time 日期
 * @param type 查询类型
 */
export async function outPutAddEnterpriseTaskList(state:number, time:number, type:number) {
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);
    
    let selectParam:any= {type:TASKTYPEENUM.新注册或迁入企业登记};

    let name = "全部";

    if (type == OUTPUTTYPE.当前数据 ) {
        if (state == 2 || state == 3) {
            selectParam.draftLock = state == 2 ? true : false;
        }
        if (time) {
            selectParam.year = new Date(time).getFullYear();
            selectParam.month = new Date(time).getMonth() + 1;
            name = `${selectParam.year}年${selectParam.month}月`;
        }
        name = "当前";
    }

    let nameMap = await fuhuaqiData.findFuHuaQiOperationNameMapByParam({});
    
    let taskList = await taskData.findTaskListByParam(selectParam);

    let dataList = [["运营机构名称", "填报状态", "数据月份", "本月新增数量"]];
    taskList.forEach(info => {
        let {submitCount, fuHuaQiUscc, month, year, isSubmit } = info;
        let name = nameMap[fuHuaQiUscc];
        let state = isSubmit? "已填报": "未填报" ;
        let dataTime = `${year}年${month}`;

        dataList.push([name, state, dataTime, submitCount]);
    });

    return { dataList, name };
}


/**
 * 获取季度任务列表
 * @param state 
 * @param year 
 * @param quarter 
 */
export async function quarterTaskList(state:number, year:number, quarter:number, page:number) {
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);

    let selectParam:any = {};

    if (state == 2) {//提交
        selectParam.draftLock = true;
    } else if (state == 3) {//未提交
        selectParam.draftLock = false;
    }
    if (year) selectParam.year = year;
    if (quarter) selectParam.quarter = quarter;

    let dataBaseList = await findBusinessDataByParamToPage(selectParam, (page-1)*10);
    let fuhuaqiNameMap = await fuhuaqiData.findFuHuaQiOperationNameMapByParam({});

    let dataList = [];
    dataBaseList.forEach(info => {
        dataList.push({
            operationName:fuhuaqiNameMap[info.fuHuaQiUscc],
            state:info.draftLock ? "已填报" : "未填报",
            time:`${info.year}年第${info.quarter}季度`,
            TR:info.TR,
            ROR:info.ROR,
            RR:info.RR,
            FS:info.FS,
            MIS:info.MIS,
            NP:info.NP,
            TP:info.TP
        });
    });

    let count = await findBusinessDataCountByParam(selectParam);

    return {count, dataList, pageCount:Math.ceil(count/10) };
}


/**
 * 导出季度任务列表
 * @param state 
 * @param year 
 * @param quarter 
 */
export async function outPutQuarterTaskDataList(type:number, state:number, year:number, quarter:number) {
    if ( !(state >=1 || state <=3) ) throw new BizError(ERRORENUM.参数错误, `state状态不合法 不合法值为 ${state}`);

    let name = "全部";
    let selectParam:any = {};

    if (type == OUTPUTTYPE.当前数据 ) {
        name = "当前";
        if (state == 2) {//提交
            selectParam.draftLock = true;
        } else if (state == 3) {//未提交
            selectParam.draftLock = false;
        }
        if (year) selectParam.year = year;
        if (quarter) selectParam.quarter = quarter;
    }


    let dataBaseList = await findBusinessDataByParam(selectParam);
    let fuhuaqiNameMap = await fuhuaqiData.findFuHuaQiOperationNameMapByParam({});

    let dataList = [["运营机构名称", "填报状态", "数据填报季度", "综合收入", "投资收入", "租金收入", "财政补贴", "其他", "净利润", "纳税"]];
    dataBaseList.forEach(info => {
        let itemList = [
            fuhuaqiNameMap[info.fuHuaQiUscc],
            info.state ? "已填报" : "未填报",
            `${info.year}年第${info.quarter}季度`,
            info.TR,
            info.ROR,
            info.RR,
            info.FS,
            info.MIS,
            info.NP,
            info.TP
        ];
        dataList.push(itemList);
    });

    return {dataList, name};
}
