/**
 * 孵化器标签管理 管理后台
 * 6.0功能
 */
import moment = require("moment");
import { findLabelLogByParam } from "../../../data/fuHuaQi/fuHuaQiLabelLog";
import { findFuHuaQiByUSCC, findFuHuaQiCount, findFuHuaQiListByPage } from "../../../data/fuHuaQi/fuhuaqi";
import { getEffectiveLabelMap } from "../../../data/label";
import { changeEnumValue } from "../../../util/verificationEnum";
import { updateLabelToFuHuaQi } from "../../label";
import { LABELGOAL, LABELTYPE, LABELUPDATEROAD, FHQSYSTEMLABEL } from "../../../config/enum/labelEnum";


/**
 * 孵化器标签列表
 * @param name 
 * @param page 
 * @param labelIdList 
 * @returns 
 */
export async function fuHuaQiLabelList(name:string, page:number, labelIdList) {
    let selectParam:any = {userState:false};
    if (name) selectParam.operationName = {"$regex":`${name}`};
    if (labelIdList.length) {
        selectParam.labels = {"$elemMatch":{labelId:{"$in":labelIdList} } }
    }

    let dbList = await findFuHuaQiListByPage(selectParam, (page-1)*10);
    let count = await findFuHuaQiCount(selectParam);
    //全量的 孵化器标签map 结构式 {id:{labelName, labelType}}
    let labelMap = await getEffectiveLabelMap(LABELGOAL.孵化器);

    let dataList = [];
    dbList.forEach(info => {
        let {name, labels, uscc} = info;
        let changeList = [];
        labels.forEach(labelItem => {
            let {state, labelId} = labelItem;
            if (labelMap[labelId]) {
                let {labelName, labelType} = labelMap[labelId];
                changeList.push({
                    state,
                    labelName,
                    labelType,
                    labelTypeStr:changeEnumValue(LABELTYPE, labelType)
                });
            }
        });
        
        dataList.push({
            name,
            labels:changeList,
            uscc
        });
    });
    
    return {count, dataList, pageCount:Math.ceil(count/10) };
}


/**
 * 孵化器标签动态列表
 * @param uscc 
 */
export async function labelLogList(uscc:string) {
    let dblist = await findLabelLogByParam({uscc});
    let labelMap = await getEffectiveLabelMap(LABELGOAL.孵化器);
    let dataList = [];

    dblist.sort((a,b) => {return b.ct - a.ct});
    
    dblist.forEach(info => {
        let {ct, road, labelId, desc} = info;
        let descStr = '';
        switch (labelId) {
            case FHQSYSTEMLABEL.专业技术平台: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            default:
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc || "张江后台更新";
            break;
        }
        dataList.push({
            logTime:moment(ct).format("YYYY-MM-DD"),
            state:road == LABELUPDATEROAD.失效 ? "失效" : "生效",
            labelName:labelMap[labelId].labelName,
            desc:descStr
        });
    });

    return {dataList};
}


/**
 * 批量添加孵化器标签
 * @param uscc 
 * @param labelIdList 生效的标签，如果传空数组，那么会清空除系统标签外的所有标签
 * @returns 
 */
export async function addFuHuaQiLabel(uscc:string, labelIdList) {
    let labelMap = await getEffectiveLabelMap(LABELGOAL.孵化器);
    let fuHuaQiInfo = await findFuHuaQiByUSCC(uscc);
    let dbLabelList = fuHuaQiInfo.labels || [];
    let newLabelList = [];
    dbLabelList.forEach(info => {
        let {labelId, state} = info;
        if (labelMap[labelId]) {
            if (state && labelMap[labelId].labelType == LABELTYPE.系统标签 ) {
                newLabelList.push(labelId);
            }
        }
    });
    await updateLabelToFuHuaQi(uscc, newLabelList.concat(labelIdList));

    return {isSuccess:true};
}


/**
 * 批量删除孵化器标签
 * @param uscc 
 * @param labelIdList 生效的标签，如果传空数组，那么会清空除系统标签外的所有标签
 * @returns 
 */
export async function deleteFuHUaQiLabel(uscc:string, labelIdList) {
    let labelMap = await getEffectiveLabelMap(LABELGOAL.孵化器);
    let fuHuaQiInfo = await findFuHuaQiByUSCC(uscc);
    let dbLabelList = fuHuaQiInfo.labels || [];
    let newLabelList = [];
    dbLabelList.forEach(info => {
        let {labelId, state} = info;
        if (labelMap[labelId]) {
            if (state && labelMap[labelId].labelType == LABELTYPE.系统标签 ) {
                newLabelList.push(labelId);
            }
        }
    });
    await updateLabelToFuHuaQi(uscc, newLabelList.concat(labelIdList));
    return {isSuccess:true};
}