/**
 * 企业标签 管理后台
 * 6.0功能
 * 
 */

import { findEnterpriseByUscc, findEnterpriseCount, findEnterpriseListToPage } from "../../../data/enterprise/enterprise";
import { findLabelLogByParam } from "../../../data/enterprise/enterpriseLabelLog";
import { getEffectiveLabelMap, selectLabelList } from "../../../data/label";
import { changeEnumValue, eccEnumValue } from "../../../util/verificationEnum";
import moment = require("moment");
import { updateLabelToEnterprise } from "../../label";
import { ENTERPRISESYSTEMLABEL, LABELGOAL, LABELTYPE, LABELUPDATEROAD } from "../../../config/enum/labelEnum";


/**
 * 企业标签列表
 * @param name 
 * @param page 
 * @param labelIdList 
 * @returns 
 */
export async function enterpriseLabelList(name:string, page:number, labelIdList) {
    let selectParam:any = {};
    if (name) selectParam.operationName = {"$regex":`${name}`};
    if (labelIdList.length) {
        selectParam.labels = {"$elemMatch":{labelId:{"$in":labelIdList} } }
    }

    let dbList = await findEnterpriseListToPage(selectParam, (page-1)*10);
    let count = await findEnterpriseCount(selectParam);
    let labelMap = await getEffectiveLabelMap(LABELGOAL.企业);

    let dataList = [];
    dbList.forEach(info => {
        let {name, labels, uscc} = info;
        let changeList = [];
        labels.forEach(labelItem => {
            let {state, labelId} = labelItem;
            if (labelMap[labelId]) {
                let {labelName, labelType} = labelMap[labelId];
                changeList.push({
                    state,
                    labelName,
                    labelType,
                    labelTypeStr:changeEnumValue(LABELTYPE, labelType)
                });
            }
        });
        
        dataList.push({
            name,
            labels:changeList,
            uscc
        });
    });
    
    return {count, dataList, pageCount:Math.ceil(count/10) };
}


/**
 * 企业标签动态列表
 * @param uscc 
 */
export async function enterpriseLabelLogList(uscc:string) {
    let dblist = await findLabelLogByParam({uscc});
    let labelMap = await getEffectiveLabelMap(LABELGOAL.企业);
    let dataList = [];
    dblist.sort((a,b) => {return b.ct - a.ct});
    dblist.forEach(info => {
        let {ct, road, labelId, desc} = info;
        let descStr = '';
        switch (labelId) {
            case ENTERPRISESYSTEMLABEL.在孵企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '孵化时间到期';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.入驻非孵: 
                if (road == LABELUPDATEROAD.失效) descStr = '企业迁出';
                else descStr = '孵化时间到期或注册地为非张江企业';
            break;
            case ENTERPRISESYSTEMLABEL.迁出企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.高新企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc || "张江后台更新";
            break;
            case ENTERPRISESYSTEMLABEL.专精特新: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.上市企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.小巨人: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.融资企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.虚拟企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.毕业企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc;
            break;
            case ENTERPRISESYSTEMLABEL.拟毕业企业: 
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = '触发条件，符合毕业企业要求';
            break;
            default:
                if (road == LABELUPDATEROAD.失效) descStr = '';
                else descStr = desc || "张江后台更新";
            break;
        }

        dataList.push({
            logTime:moment(ct).format("YYYY-MM-DD"),
            state:road == LABELUPDATEROAD.失效 ? "失效" : "生效",
            labelName:labelMap[labelId].labelName,
            desc:descStr
        });
    });

    return {dataList};
}


/**
 * 批量添加企业标签
 * @param uscc 
 * @param labelIdList 
 * @returns 
 */
export async function addEnterpriseLabel(uscc:string, labelIdList) {
    //只能添加自定义标签
    let labelMap = await getEffectiveLabelMap(LABELGOAL.企业);
    let enterpriseInfo = await findEnterpriseByUscc(uscc);
    let dbLabelList = enterpriseInfo.labels || [];
    let newLabelList = [];
    dbLabelList.forEach(info => {
        let {labelId, state} = info;
        if (labelMap[labelId]) {
            if (state && labelMap[labelId].labelType == LABELTYPE.系统标签 ) {
                newLabelList.push(labelId);
            }
        }
    });

    await updateLabelToEnterprise(uscc, newLabelList.concat(labelIdList));

    return {isSuccess:true};
}


/**
 * 批量删除企业标签
 * @param uscc 
 * @param labelIdList 
 * @returns 
 */
export async function deleteEnterpriseLabel(uscc:string, labelIdList) {
    let labelMap = await getEffectiveLabelMap(LABELGOAL.企业);
    let enterpriseInfo = await findEnterpriseByUscc(uscc);
    let dbLabelList = enterpriseInfo.labels || [];
    let newLabelList = [];
    dbLabelList.forEach(info => {
        let {labelId, state} = info;
        if (labelMap[labelId]) {
            if (state && labelMap[labelId].labelType == LABELTYPE.系统标签 ) {
                newLabelList.push(labelId);
            }
        }
    });

    await updateLabelToEnterprise(uscc, newLabelList.concat(labelIdList));
    return {isSuccess:true};
}


/**
 * 标签管理选择框
 * @param goal 
 * @returns 
 */
export async function getLabelListByGoal(goal:number) {
    eccEnumValue("获取标签管理", "goal", LABELGOAL, goal );
    let list = await selectLabelList({goal, state:false, labelType:LABELTYPE.自定义标签});
    let dataList = [];

    list.forEach(info => {
        dataList.push({
            key:info.labelName,
            value:info.id
        });
    });

    return {dataList}
}