/**
 * 校验数据逻辑
 */

import moment = require("moment");
import { CYCSRBJ, CYCXFX, ENTERPRISESIZE, FINANCINGROUNDS, FUHUAQICUSTOMTASKTYPE, FUHUASTATE, INDUSTRY, MOVEOUTCAUSE, MOVEOUTTRACE, MOVEOUTTYPE, NASHUIRENZIZHI, OUTPUTTYPE, RAS, VIRTUALCAUSE } from "../../../config/enum";
import { getNewMonthTask } from "../../../data/fuHuaQi/customTask";
import { findEnterpriseCount, findEnterpriseList, findEnterpriseListToPage, selectOneEnterpriseByParam } from "../../../data/enterprise/enterprise";
import { extractData } from "../../../util/piecemeal";
import { EnterpriseListConfig, EnterpriseMoveOutListConfig } from "../../../config/splitResultConfig";
import { findFuHuaQiOperationNameMapByParam } from "../../../data/fuHuaQi/fuhuaqi";
import { changeEnumValue } from "../../../util/verificationEnum";
import { changeAddToString } from "../../../tools/system";
import { outPutMonthTableList } from "../fuHuaQi/month";
import { addressIsInZJ, latLngInZJ } from "../../../tools/transCode";
import { outPutFinancingList } from "../enterprise/financing";

function changeTimeStr(dataCycle) {
    let dataCycleStr = `${dataCycle}`;
    return `${dataCycleStr.slice(0,4)}-${dataCycleStr.slice(4,6)}-01 00:00:00`;
}
export async function checkEnterpriseDataList(page:number) {
    /**获取最新数据月份 */
    
    let dataMonthInfo = await getNewMonthTask(FUHUAQICUSTOMTASKTYPE.月度任务);
    let startMs = moment(changeTimeStr(dataMonthInfo.dataCycle)).add(1, 'M').valueOf();
   
    let endMs = moment(startMs).add(1, 'M').valueOf();
    let usccMap = await findFuHuaQiOperationNameMapByParam({});//用于将孵化器uscc变成孵化器名称
    /**找目标月入库的数据 */
    let param = {
        createTime:{"$gt":startMs, "$lt":endMs}
    }
    let enterpriseList = await findEnterpriseListToPage(param, (page-1) * 10);
    let enterpriseCount = await findEnterpriseCount(param);
    let dataList = [];
    enterpriseList.forEach(info => {
        /**截取返回数据 */ 
        let changeData:any = extractData(EnterpriseListConfig, info, true);

        /**匹配所属孵化器名称  匹配不上时这里显示空字符串 */
        changeData.fuhuaqiUscc = usccMap[info.fuHuaQiUscc] || "";

        /** 返回的isCreate字段为字符串 当为导入数据时这里显示为空字符  */
        if (!info.taskId || info.enterpriseIsInPut) {
            if (info.enterpriseIsInPut) changeData.isCreate = "底库数据";
            else {
                changeData.isCreate =  (changeData.isCreate)? "补录新注册":"补录新迁入";
            }
        }
        else changeData.isCreate = (changeData.isCreate) ? "新注册" : "新迁入";

        changeData.state = changeEnumValue(FUHUASTATE, changeData.state);
        changeData.virtualCause = !changeData.virtualCause ? '-' : changeEnumValue(VIRTUALCAUSE, changeData.virtualCause);

        if (!changeAddToString(info.oldLogonAddress)) {
            changeData.oldLogonAddress = "-";
        }
        if (!changeAddToString(info.logonAddress)) {
            changeData.logonAddress = "-";
        }
        if (!changeAddToString(info.operatingAddress)) {
            changeData.operatingAddress = "-";
        }

        /**将枚举值转为字符 */
        changeData.industry = changeEnumValue(INDUSTRY, changeData.industry);
        changeData.cycxfx = changeEnumValue(CYCXFX, changeData.cycxfx) || "未选择";
        changeData.cycsrbj = changeEnumValue(CYCSRBJ, changeData.cycsrbj) || "未选择";

        let intellectualProperty = changeData.intellectualProperty || {}
        changeData.alienPatent =  intellectualProperty.alienPatent || 0;
        changeData.classIPatent =  intellectualProperty.classIPatent || 0;
        changeData.secondClassPatent =  intellectualProperty.secondClassPatent || 0;

        if (changeData.qualification) {
            let onceData = changeData.qualification;
            let beOnTheMarket = "无上市";
            if (changeData.qualification.beOnTheMarket){
                beOnTheMarket = changeEnumValue( FINANCINGROUNDS, onceData.beOnTheMarket)
            }

            let qualificationList = [{
                beOnTheMarket,
                highTechMs: onceData.highTechMs ? new Date(onceData.highTechMs).getFullYear() : '未认证',//高新技术
                zjtxMs: onceData.zjtxMs ? new Date(onceData.zjtxMs).getFullYear() : '未认证',//专精特新
                xjrpyMs: onceData.xjrpyMs ? new Date(onceData.xjrpyMs).getFullYear() : '未认证',//小巨人培育
                xjrMs: onceData.xjrMs ? new Date(onceData.xjrMs).getFullYear() : '未认证',//小巨人
            }];

            changeData.qualification = qualificationList;
        } else {
            changeData.qualification = [{
                beOnTheMarket:"无上市",
                highTechMs: '未认证',//高新技术
                zjtxMs: '未认证',//专精特新
                xjrpyMs: '未认证',//小巨人培育
                xjrMs: '未认证',//小巨人
            }]
        }
        
        dataList.push(changeData);
    });
    let title = `${moment(startMs).format("YYYY年MM月")}数据新入孵${enterpriseCount}家`;
    return {dataList, count:enterpriseCount, title};
}

export async function dwEnterpriseDataList() {
    /**获取最新数据月份 */
    
    let dataMonthInfo = await getNewMonthTask(FUHUAQICUSTOMTASKTYPE.月度任务);
    let startMs = moment(changeTimeStr(dataMonthInfo.dataCycle)).add(1, 'M').valueOf();
   
    let endMs = moment(startMs).add(1, 'M').valueOf();
    let usccMap = await findFuHuaQiOperationNameMapByParam({});//用于将孵化器uscc变成孵化器名称
    /**找目标月入库的数据 */
    let param = {
        createTime:{"$gt":startMs, "$lt":endMs},
        "$or" : [{"$and":[{"draftLock":true}, {"taskId":{"$ne":null}}]}, {"$and":[{"draftLock":false}, {"taskId":null}]}] //未提交的企业不能查看
    }
    let enterpriseList = await findEnterpriseList(param);
    let enterpriseCount = await findEnterpriseCount(param);
    /**组合二维数组  titleList 与 keyList 要一一对应 */ 
    const TitleList = [
        "企业名称", "入库时间", "所属孵化器", "新注册/新迁入", "孵化状态", "虚拟孵化服务模式", "统一信用代码", "行业领域","主营业务",
        "注册时间", "首次入孵时间", "迁入时间", "是否自然人控股", "迁入前注册地址",
        "注册地址", "经营地址", "租赁面积（平方米）","创业创新方向","创业创始人背景",
        "海外专利", "一类专利","二类专利", 
        "是否上市" , "高新技术" , "专精特新" , "小巨人培育" , "小巨人"
    ];//表头顺序  如果这里修改了 下面的keyList也要修改
    const KeyList = [
        "name", "createTime", "fuhuaqiUscc", "isCreate",  "state", "virtualCause", "uscc", "industry", "mainBusiness", 
        "logonTime","firstIncubationTime", "timeOfImmigration", "isNaturalPersonHolding", "oldLogonAddress",
        "logonAddress", "operatingAddress", "leasedArea","cycxfx","cycsrbj",
        "alienPatent", "classIPatent", "secondClassPatent",
        "beOnTheMarket", "highTechMs", "zjtxMs", "xjrpyMs", "xjrMs"
    ];//表头对应的字段顺序
    let dataList = [TitleList];
    
    enterpriseList.forEach( info => {
        /**截取返回结果 */
        let changeData:any = extractData(EnterpriseListConfig, info, true);

        /**匹配所属孵化器名称  匹配不上时这里显示空字符串 */
        changeData.fuhuaqiUscc = usccMap[info.fuHuaQiUscc] || "";
        if (!info.taskId || info.enterpriseIsInPut) {
            if (info.enterpriseIsInPut) changeData.isCreate = "底库数据";
            else {
                changeData.isCreate =  (changeData.isCreate)? "补录新注册":"补录新迁入";
            }
        }else changeData.isCreate = (changeData.isCreate) ? "新注册" : "新迁入";

        if (!changeAddToString(info.oldLogonAddress)) {
            changeData.oldLogonAddress = "-";
        }
        if (!changeAddToString(info.logonAddress)) {
            changeData.logonAddress = "-";
        }
        if (!changeAddToString(info.operatingAddress)) {
            changeData.operatingAddress = "-";
        }

        changeData.cycxfx = changeEnumValue(CYCXFX, changeData.cycxfx) || "未选择";
        changeData.cycsrbj = changeEnumValue(CYCSRBJ, changeData.cycsrbj) || "未选择";

        changeData.isNaturalPersonHolding = changeData.isNaturalPersonHolding ? "是" : "否";

        /**修改枚举值 */
        changeData.industry = changeEnumValue(INDUSTRY, changeData.industry);
        changeData.state = changeEnumValue(FUHUASTATE, changeData.state);
        changeData.virtualCause = changeEnumValue(VIRTUALCAUSE, changeData.virtualCause);
        
        /**- */
        let intellectualProperty = changeData.intellectualProperty || {}
        changeData.alienPatent =  intellectualProperty.alienPatent || 0;
        changeData.classIPatent =  intellectualProperty.classIPatent || 0;
        changeData.secondClassPatent =  intellectualProperty.secondClassPatent || 0;

        if (changeData.qualification) {
            let onceData = changeData.qualification;
            let beOnTheMarket = "无上市";
            if (onceData.beOnTheMarket){
                beOnTheMarket = changeEnumValue( FINANCINGROUNDS, onceData.beOnTheMarket) || "无上市"
            }

            changeData.beOnTheMarket = beOnTheMarket;
            changeData.highTechMs = onceData.highTechMs ? new Date(onceData.highTechMs).getFullYear() : '未认证';//高新技术
            changeData.zjtxMs = onceData.zjtxMs ? new Date(onceData.zjtxMs).getFullYear() : '未认证';//专精特新
            changeData.xjrpyMs = onceData.xjrpyMs ? new Date(onceData.xjrpyMs).getFullYear() : '未认证';//小巨人培育
            changeData.xjrMs = onceData.xjrMs ? new Date(onceData.xjrMs).getFullYear() : '未认证';//小巨人

        } else {
            changeData.beOnTheMarket = "无上市";//是否上市
            changeData.highTechMs =  '未认证';//高新技术
            changeData.zjtxMs =  '未认证';//专精特新
            changeData.xjrpyMs =  '未认证';//小巨人培育
            changeData.xjrMs =  '未认证';//小巨人
        }
        
        /**根据表头与key的顺序 生成小数组 */
        let subList = [];
        KeyList.forEach( keyStr => {
            let value = changeData[keyStr];
            if (value == null || value == undefined) value = "-"
            subList.push( value );
        });
        dataList.push(subList);
    });
    let title = `${moment(startMs).format("YYYY年MM月")}数据新入孵${enterpriseCount}家`;
    return {dataList, count:enterpriseCount, title};
}

/**
 * 注意工作流程，这里以后用uscc匹配企查查数据，匹配不到的证明企业信用代码不对
 * @param list 
 */
export async function upCheckEnterpriseData(dataList) {
        
    //比对名称和uscc 有一个相同认为是同一个公司
    let fhqNameMap = await findFuHuaQiOperationNameMapByParam({});

    let notCheckList = [];
    for (let i = 1; i < dataList.length; i++) {
        let itemList = dataList[i];

        let 原文件导入名称 = itemList[0];
        let 系统匹配企业名称 = itemList[1];
        let 登记状态 = itemList[2];
        let 法定代表人 = itemList[3];
        let 注册资本 = itemList[4];
        let 实缴资本 = itemList[5];
        let 成立日期 = itemList[6];
        let 统一社会信用代码 = itemList[7];
        let 企业地址 = itemList[8];
        let 所属省份 = itemList[9];
        let 所属城市 = itemList[10];
        let 所属区县 = itemList[11];
        let 电话 = itemList[12];
        let 更多电话 = itemList[13];
        let 邮箱 = itemList[14];
        let 更多邮箱 = itemList[15];
        let 企业机构类型 = itemList[16];
        let 纳税人识别号 = itemList[17];
        let 注册号 = itemList[18];
        let 组织机构代码 = itemList[19];
        let 参保人数 = itemList[20];
        let 参保人数所属年报 = itemList[21];
        let 核准日期 = itemList[22];
        let 营业期限 = itemList[23];
        let 国标行业门类 = itemList[24];
        let 国标行业大类 = itemList[25];
        let 国标行业中类 = itemList[26];
        let 国标行业小类 = itemList[27];
        let 企查查行业门类 = itemList[28];
        let 企查查行业大类 = itemList[29];
        let 企查查行业中类 = itemList[30];
        let 企查查行业小类 = itemList[31];
        let 企业规模 = itemList[32];
        let 曾用名 = itemList[33];
        let 英文名 = itemList[34];
        let 官网 = itemList[35];
        let 通信地址 = itemList[36];
        let 企业简介 = itemList[37];
        let 经营范围 = itemList[38];
        let 登记机关 = itemList[39];
        let 纳税人资质 = itemList[40];
        let 最新年报年份 = itemList[41];
        let 企业经营状态 = itemList[42];
        let selectUscc = 统一社会信用代码 == "-" ? 原文件导入名称 : 统一社会信用代码; 
        let enterpriseInfo = await selectOneEnterpriseByParam({uscc:selectUscc});
        if (!enterpriseInfo || !enterpriseInfo.uscc) {
            notCheckList.push({index:i, uscc:selectUscc, name:系统匹配企业名称});
            continue;
        }
        enterpriseInfo.name = 系统匹配企业名称;
        /**核对基础信息，注册时间，注册地址，经营地址等 */
        if (成立日期 != "-") {
            enterpriseInfo.logonTime = new Date(成立日期).valueOf();
        }
        enterpriseInfo.logonAddress = [所属省份, 所属城市, 所属区县, 企业地址 ];
        if (经营范围 != "-" && enterpriseInfo.mainBusiness) {
            enterpriseInfo.mainBusiness = 经营范围;
        }
        let ras = RAS.续存;
        if (登记状态.indexOf("注销") != -1) {
            //企业注销  注销将企业改成迁出
            let 等级状态数组 = 登记状态.split("(");
            if (等级状态数组[1]) {
                enterpriseInfo.logOffMS = new Date(等级状态数组[1].replace(")", "")).valueOf();
            }
            enterpriseInfo.state = FUHUASTATE.迁出;
            enterpriseInfo.moveOutType = MOVEOUTTYPE.企业注销;
            ras = RAS.注销;
        }

        /** 增补字段 */
        enterpriseInfo.RAS = ras;//登记状态
        enterpriseInfo.legalPerson = 法定代表人;//法人
        enterpriseInfo.zhuceziben = 注册资本;//注册资本
        enterpriseInfo.shijiaoziben = 实缴资本;//实缴资本
        enterpriseInfo.dianHua = 电话;//电话
        enterpriseInfo.gengDuoDianHua = 更多电话;//更多电话
        enterpriseInfo.mail = 邮箱;//邮箱
        enterpriseInfo.moreMail = 更多邮箱;//更多邮箱
        enterpriseInfo.enterpriseType = 企业机构类型;//企业（机构）类型
        enterpriseInfo.zhuCeHao = 注册号;//注册号
        enterpriseInfo.zuZhiJiGouDaiMa = 组织机构代码;//组织机构代码
        enterpriseInfo.canBaoRenShu = 参保人数 == "-" || !参保人数 ? 0: parseInt(参保人数);  //参保人数
        enterpriseInfo.canBaoRenShuNianBao = 参保人数所属年报 == "-" || !参保人数所属年报 ? 0: parseInt(参保人数所属年报);  //参保人数所属年报
        enterpriseInfo.yingYeQiXian = 营业期限;//营业期限
        switch (企业规模) {
            case 'XS(微型)':  enterpriseInfo.qiYeGuiMo = ENTERPRISESIZE.微型;break;
            case 'S(小型)':  enterpriseInfo.qiYeGuiMo = ENTERPRISESIZE.小型;break;
            case 'M(中型)':  enterpriseInfo.qiYeGuiMo = ENTERPRISESIZE.中型;break;
            case 'L(大型)':  enterpriseInfo.qiYeGuiMo = ENTERPRISESIZE.大型;break;
            default:  enterpriseInfo.qiYeGuiMo = ENTERPRISESIZE.未知;break;
        }
        enterpriseInfo.guanWang = 官网;//官网
        enterpriseInfo.tongXinDiZhi = 通信地址;//通信地址
        enterpriseInfo.jianJie = 企业简介;//企业简介
        enterpriseInfo.dengJiJiGuan = 登记机关;//登记机关
        switch (纳税人资质) {
            case 'XS(微型)':  enterpriseInfo.naShuiRenZiZhi = NASHUIRENZIZHI.一般纳税人;break;
            case '增值税一般纳税人':  enterpriseInfo.naShuiRenZiZhi = NASHUIRENZIZHI.增值税一般纳税人;break;
            case 'M(中型)':  enterpriseInfo.naShuiRenZiZhi = NASHUIRENZIZHI.小规模纳税人;break;
            default:   enterpriseInfo.naShuiRenZiZhi = NASHUIRENZIZHI.未知;break;
        }
        enterpriseInfo.zuiXinNianBaoNianFen = isNaN(最新年报年份) ? 0: parseInt(最新年报年份);  //最新年报年份

        await enterpriseInfo.save();
    }

    return {isSuccess:true, notCheckList};
}


/**
 * 月报数据源下载
 */
export async function monthData() {
    let dataMonthInfo = await getNewMonthTask(FUHUAQICUSTOMTASKTYPE.月度任务);
    let year = new Date(changeTimeStr(dataMonthInfo.dataCycle)).getFullYear();
    let month = new Date(changeTimeStr(dataMonthInfo.dataCycle)).getMonth() + 1;
   
    // /**月度任务 */
    // let monthDataList = await outPutMonthTableList(0, year, month, OUTPUTTYPE.当前数据 );
    // /**新入孵数据 */
    // let ruFuData = await dwEnterpriseDataList();
    // /**新注册新迁入 */
    // let {qianRuList, createList} = await monthEnterpriseStats();
    // /** 融资*/
    // let financingDataStr = moment(changeTimeStr(dataMonthInfo.dataCycle)).add(1, 'M').format("YYYY-MM-DD");
    // let financingList = await outPutFinancingList(`${financingDataStr} 00:00:00`, "", [], 1, OUTPUTTYPE.当前数据, false);

    let {thisYearDataList, thisYearQianRuList} = await t1();

    
    let  thisYearFinancingList = [];
    for (let i = 2; i < 8; i++) {
        let itemList = await outPutFinancingList(`2024-07-0${i} 00:00:00`, "", [], 1, OUTPUTTYPE.当前数据, false);
        thisYearFinancingList = thisYearFinancingList.concat(thisYearFinancingList, itemList)
    }

    return {
        title:"月报数据下载",
        dataList:[
            // {
            //     sheetName:"孵化器基本情况",
            //     data:monthDataList
            // },
            // {
            //     sheetName:"新入孵数据情况源数据",
            //     data:ruFuData.dataList
            // },
            // {
            //     sheetName:"新注册",
            //     data:createList
            // },
            // {
            //     sheetName:"新迁入",
            //     data:qianRuList
            // },
            // {
            //     sheetName:"融资",
            //     data:financingList
            // },
            // {
            //     sheetName:`${2024}年1-${7}月累计融资企业汇总统计`,
            //     data:thisYearFinancingList
            // },
            {
                sheetName:`${year}年1-${month}月累计新迁入企业汇总统计`,
                data:thisYearQianRuList, 
            },
            {
                sheetName:`${year}年1-${month}月累计新注册企业汇总统计`,
                data:thisYearDataList, 
            }
           
        ]
    }
}

async function monthEnterpriseStats() {
    /**获取最新数据月份 */
    let thisYearStartMs = new Date(`${new Date().getFullYear()}-01-01 00:00:00`).valueOf();
    let dataMonthInfo = await getNewMonthTask(FUHUAQICUSTOMTASKTYPE.月度任务);
    let startMs = moment(changeTimeStr(dataMonthInfo.dataCycle)).add(1, 'M').valueOf();
   
    let endMs = moment(startMs).add(1, 'M').valueOf();
    let usccMap = await findFuHuaQiOperationNameMapByParam({});//用于将孵化器uscc变成孵化器名称
    /**找目标月入库的数据 */
    let param = {
        createTime:{"$gt":startMs, "$lt":endMs},
        "$or" : [{"$and":[{"draftLock":true}, {"taskId":{"$ne":null}}]}, {"$and":[{"draftLock":false}, {"taskId":null}]}] //未提交的企业不能查看
    }
    let enterpriseList = await findEnterpriseList(param);
    /**组合二维数组  titleList 与 keyList 要一一对应 */ 
    const TitleList = [
        "企业名称", "入库时间", "所属孵化器", "新注册/新迁入", "孵化状态", "虚拟孵化服务模式", "统一信用代码", "行业领域","主营业务",
        "注册时间", "首次入孵时间", "迁入时间", "是否自然人控股", "迁入前注册地址",
        "注册地址", "经营地址", "租赁面积（平方米）","创业创新方向","创业创始人背景",
        "海外专利", "一类专利","二类专利", 
        "是否上市" , "高新技术" , "专精特新" , "小巨人培育" , "小巨人"
    ];//表头顺序  如果这里修改了 下面的keyList也要修改
    const KeyList = [
        "name", "createTime", "fuhuaqiUscc", "isCreate",  "state", "virtualCause", "uscc", "industry", "mainBusiness", 
        "logonTime","firstIncubationTime", "timeOfImmigration", "isNaturalPersonHolding", "oldLogonAddress",
        "logonAddress", "operatingAddress", "leasedArea","cycxfx","cycsrbj",
        "alienPatent", "classIPatent", "secondClassPatent",
        "beOnTheMarket", "highTechMs", "zjtxMs", "xjrpyMs", "xjrMs"
    ];//表头对应的字段顺序
    let dataList = [TitleList];
    
    let qianRuList = [TitleList];
    for (let i =0; i < enterpriseList.length; i++) {
        let info = enterpriseList[i];
        let logonAddressSuccess = false;
        let logonTimeIsThisYear = false;
        if (info.logonAddress) {
            let isInZJ = await addressIsInZJ(changeAddToString(info.logonAddress));
            if (isInZJ) {
                logonAddressSuccess = true;
            }
        }
        if (info.logonTime > thisYearStartMs) {
            logonTimeIsThisYear = true;
        }

        let isCreate = false;
        let isQianRu = false;
        
        //迁入
        if (info.oldLogonAddress && info.oldLogonAddress.length && info.oldLogonAddress[0]) {
            let qianRuIsZJ = await addressIsInZJ(changeAddToString(info.oldLogonAddress));
            if (!qianRuIsZJ) {//非张江
                if (logonAddressSuccess) isQianRu = true;
            } else {//张江
                if (logonAddressSuccess && logonTimeIsThisYear) isCreate = true;
            }
        }
        //新注册
        if (info.isCreate) {
            if (logonAddressSuccess && logonTimeIsThisYear) {
                isCreate = true;
            }
        }



        /**截取返回结果 */
        let changeData:any = extractData(EnterpriseListConfig, info, true);

        /**匹配所属孵化器名称  匹配不上时这里显示空字符串 */
        changeData.fuhuaqiUscc = usccMap[info.fuHuaQiUscc] || "";
        if (!info.taskId || info.enterpriseIsInPut) {
            if (info.enterpriseIsInPut) changeData.isCreate = "底库数据";
            else {
                changeData.isCreate =  (changeData.isCreate)? "补录新注册":"补录新迁入";
            }
        }else changeData.isCreate = (changeData.isCreate) ? "新注册" : "新迁入";

        if (!changeAddToString(info.oldLogonAddress)) {
            changeData.oldLogonAddress = "-";
        }
        if (!changeAddToString(info.logonAddress)) {
            changeData.logonAddress = "-";
        }
        if (!changeAddToString(info.operatingAddress)) {
            changeData.operatingAddress = "-";
        }

        changeData.cycxfx = changeEnumValue(CYCXFX, changeData.cycxfx) || "未选择";
        changeData.cycsrbj = changeEnumValue(CYCSRBJ, changeData.cycsrbj) || "未选择";

        changeData.isNaturalPersonHolding = changeData.isNaturalPersonHolding ? "是" : "否";

        /**修改枚举值 */
        changeData.industry = changeEnumValue(INDUSTRY, changeData.industry);
        changeData.state = changeEnumValue(FUHUASTATE, changeData.state);
        changeData.virtualCause = changeEnumValue(VIRTUALCAUSE, changeData.virtualCause);
        
        /**- */
        let intellectualProperty = changeData.intellectualProperty || {}
        changeData.alienPatent =  intellectualProperty.alienPatent || 0;
        changeData.classIPatent =  intellectualProperty.classIPatent || 0;
        changeData.secondClassPatent =  intellectualProperty.secondClassPatent || 0;

        if (changeData.qualification) {
            let onceData = changeData.qualification;
            let beOnTheMarket = "无上市";
            if (onceData.beOnTheMarket){
                beOnTheMarket = changeEnumValue( FINANCINGROUNDS, onceData.beOnTheMarket) || "无上市"
            }

            changeData.beOnTheMarket = beOnTheMarket;
            changeData.highTechMs = onceData.highTechMs ? new Date(onceData.highTechMs).getFullYear() : '未认证';//高新技术
            changeData.zjtxMs = onceData.zjtxMs ? new Date(onceData.zjtxMs).getFullYear() : '未认证';//专精特新
            changeData.xjrpyMs = onceData.xjrpyMs ? new Date(onceData.xjrpyMs).getFullYear() : '未认证';//小巨人培育
            changeData.xjrMs = onceData.xjrMs ? new Date(onceData.xjrMs).getFullYear() : '未认证';//小巨人

        } else {
            changeData.beOnTheMarket = "无上市";//是否上市
            changeData.highTechMs =  '未认证';//高新技术
            changeData.zjtxMs =  '未认证';//专精特新
            changeData.xjrpyMs =  '未认证';//小巨人培育
            changeData.xjrMs =  '未认证';//小巨人
        }
        
        /**根据表头与key的顺序 生成小数组 */
        let subList = [];
        KeyList.forEach( keyStr => {
            let value = changeData[keyStr];
            if (value == null || value == undefined) value = "-"
            subList.push( value );
        });

        if (isQianRu) qianRuList.push(subList)
        if (isCreate) dataList.push(subList);

    }

    return {createList:dataList, qianRuList:qianRuList};

}

async function t1() {
    
    /** */
    let thisYearStartMs = new Date(`${new Date().getFullYear()}-01-01 00:00:00`).valueOf();
    const TitleList = [
        "月份","企业名称", "入库时间", "所属孵化器", "新注册/新迁入", "孵化状态", "虚拟孵化服务模式", "统一信用代码", "行业领域","主营业务",
        "注册时间", "首次入孵时间", "迁入时间", "是否自然人控股", "迁入前注册地址",
        "注册地址", "经营地址", "租赁面积（平方米）","创业创新方向","创业创始人背景",
        "海外专利", "一类专利","二类专利", 
        "是否上市" , "高新技术" , "专精特新" , "小巨人培育" , "小巨人"
    ];//表头顺序  如果这里修改了 下面的keyList也要修改
    let thisYearDataList = [TitleList];    
    let thisYearQianRuList = [TitleList];


        let usccMap = await findFuHuaQiOperationNameMapByParam({});//用于将孵化器uscc变成孵化器名称
        /**找目标月入库的数据 */
        let param = {
            createTime:{"$gt":new Date("2024-01-01 00:00:00").valueOf()},
            "$or" : [{"$and":[{"draftLock":true}, {"taskId":{"$ne":null}}]}, {"$and":[{"draftLock":false}, {"taskId":null}]}] //未提交的企业不能查看
        }
        let enterpriseList = await findEnterpriseList(param);
        /**组合二维数组  titleList 与 keyList 要一一对应 */ 
       
        const KeyList = [
            "name", "createTime", "fuhuaqiUscc", "isCreate",  "state", "virtualCause", "uscc", "industry", "mainBusiness", 
            "logonTime","firstIncubationTime", "timeOfImmigration", "isNaturalPersonHolding", "oldLogonAddress",
            "logonAddress", "operatingAddress", "leasedArea","cycxfx","cycsrbj",
            "alienPatent", "classIPatent", "secondClassPatent",
            "beOnTheMarket", "highTechMs", "zjtxMs", "xjrpyMs", "xjrMs"
        ];//表头对应的字段顺序
        
        for (let i =0; i < enterpriseList.length; i++) {
            let info = enterpriseList[i];
            let logonTimeIsThisYear = false;
            if (info.logonAddress) {
               
            }
            if (info.logonTime > thisYearStartMs) {
                logonTimeIsThisYear = true;
            }

            let isCreate = false;
            let isQianRu = false;
            
            //迁入
            if (info.oldLogonAddress && info.oldLogonAddress.length && info.oldLogonAddress[0]) {
                let qianRuIsZJ = await latLngInZJ(parseFloat(info.oldLat), parseFloat(info.oldLng));
                if (!qianRuIsZJ) {//非张江
                    let logonAddressSuccess = await latLngInZJ(parseFloat(info.lat), parseFloat(info.lng));
                    if (logonAddressSuccess) isQianRu = true;
                } else {//张江
                    if (logonTimeIsThisYear) {
                        let logonAddressSuccess = await latLngInZJ(parseFloat(info.lat), parseFloat(info.lng));
                        if (logonAddressSuccess) isCreate = true;
                    }
                    
                }
            }
            //新注册
            if (info.isCreate) {
                if (logonTimeIsThisYear) {
                    isCreate = await latLngInZJ(parseFloat(info.lat), parseFloat(info.lng));
                }
            }



            /**截取返回结果 */
            let changeData:any = extractData(EnterpriseListConfig, info, true);

            /**匹配所属孵化器名称  匹配不上时这里显示空字符串 */
            changeData.fuhuaqiUscc = usccMap[info.fuHuaQiUscc] || "";
            if (!info.taskId || info.enterpriseIsInPut) {
                if (info.enterpriseIsInPut) changeData.isCreate = "底库数据";
                else {
                    changeData.isCreate =  (changeData.isCreate)? "补录新注册":"补录新迁入";
                }
            }else changeData.isCreate = (changeData.isCreate) ? "新注册" : "新迁入";

            if (!changeAddToString(info.oldLogonAddress)) {
                changeData.oldLogonAddress = "-";
            }
            if (!changeAddToString(info.logonAddress)) {
                changeData.logonAddress = "-";
            }
            if (!changeAddToString(info.operatingAddress)) {
                changeData.operatingAddress = "-";
            }

            changeData.cycxfx = changeEnumValue(CYCXFX, changeData.cycxfx) || "未选择";
            changeData.cycsrbj = changeEnumValue(CYCSRBJ, changeData.cycsrbj) || "未选择";

            changeData.isNaturalPersonHolding = changeData.isNaturalPersonHolding ? "是" : "否";

            /**修改枚举值 */
            changeData.industry = changeEnumValue(INDUSTRY, changeData.industry);
            changeData.state = changeEnumValue(FUHUASTATE, changeData.state);
            changeData.virtualCause = changeEnumValue(VIRTUALCAUSE, changeData.virtualCause);
            
            /**- */
            let intellectualProperty = changeData.intellectualProperty || {}
            changeData.alienPatent =  intellectualProperty.alienPatent || 0;
            changeData.classIPatent =  intellectualProperty.classIPatent || 0;
            changeData.secondClassPatent =  intellectualProperty.secondClassPatent || 0;

            if (changeData.qualification) {
                let onceData = changeData.qualification;
                let beOnTheMarket = "无上市";
                if (onceData.beOnTheMarket){
                    beOnTheMarket = changeEnumValue( FINANCINGROUNDS, onceData.beOnTheMarket) || "无上市"
                }

                changeData.beOnTheMarket = beOnTheMarket;
                changeData.highTechMs = onceData.highTechMs ? new Date(onceData.highTechMs).getFullYear() : '未认证';//高新技术
                changeData.zjtxMs = onceData.zjtxMs ? new Date(onceData.zjtxMs).getFullYear() : '未认证';//专精特新
                changeData.xjrpyMs = onceData.xjrpyMs ? new Date(onceData.xjrpyMs).getFullYear() : '未认证';//小巨人培育
                changeData.xjrMs = onceData.xjrMs ? new Date(onceData.xjrMs).getFullYear() : '未认证';//小巨人

            } else {
                changeData.beOnTheMarket = "无上市";//是否上市
                changeData.highTechMs =  '未认证';//高新技术
                changeData.zjtxMs =  '未认证';//专精特新
                changeData.xjrpyMs =  '未认证';//小巨人培育
                changeData.xjrMs =  '未认证';//小巨人
            }
            
            /**根据表头与key的顺序 生成小数组 */
            let subList = [];
            subList.push(new Date(info.createTime).getMonth() + 1)
            KeyList.forEach( keyStr => {
                let value = changeData[keyStr];
                if (value == null || value == undefined) value = "-"
                subList.push( value );
            });

            if (isQianRu) thisYearDataList.push(subList)
            if (isCreate) thisYearQianRuList.push(subList);
        }
        thisYearDataList.sort((a:any, b:any) => {return a[0]-b[0]});
        thisYearQianRuList.sort((a:any, b:any) => {return a[0]-b[0]});
    return {thisYearDataList, thisYearQianRuList}
}