/**
 * 活动
 */

/**
 * 管理后台 资讯逻辑
 * 作者：lxm
 */

import moment = require("moment");
import * as activityData from "../data/activity";
import * as demandData from "../data/fuHuaQi/demand";
import { getInformationId } from "../tools/system";
import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "../util/bizError";
import { changeEnumManyValue } from "../util/verificationEnum";
import { VISITDEMAND } from "../config/enum";

/**
 * 管理后台添加资讯
 * @param desc 内容
 * @param title 标题
 * @param source 来源
 * @param coverImg 封面图片地址
 * @returns 
 */
export async function addOnceInformation(desc:string, title:string ,source:string, coverImg:string, startTime:Number, endTime:Number, target ) {
    let id = getInformationId();
    await activityData.createActivity(id, desc, title, source, coverImg, startTime, endTime, target);

    return {isSuccess:true};
}


/**
 * 打开资讯
 * @param id 标识
 * @param isPermanent 是否永久有效
 * @param closeTimeMs 有效时间
 * @returns 
 */
export async function openInformation(id:string, isPermanent:boolean, closeTimeMs:number) {
    if ( isPermanent ) closeTimeMs = 0;
    else {
        if (!closeTimeMs) throw new BizError(ERRORENUM.参数错误, "开启任务时 缺少创建时间");
    }

    let dataBaseData = await activityData.selectActivityDataById(id);
    if (dataBaseData.state) throw new BizError(ERRORENUM.请不要重复开启资讯);

    dataBaseData.isPermanent = isPermanent;
    dataBaseData.closeTimeMs = closeTimeMs;
    dataBaseData.state = true;

    await dataBaseData.save();

    return {isSuccess:true};
}


/**
 * 关闭资讯
 * @param id 资讯标识
 * @returns 
 */
export async function closeInformation(id:string) {
    let dataBaseData = await activityData.selectActivityDataById(id);

    dataBaseData.state = false;
    await dataBaseData.save();

    return {isSuccess:true};
}


/**
 * 回显示资讯信息
 * @param id 标识
 * @returns 
 */
export async function selectOnceInformationDate(id:string) {
    let onceDataInfo = await activityData.selectActivityDataById(id);

    let result = {
        id:onceDataInfo.id,
        title:onceDataInfo.title,
        desc:onceDataInfo.desc,
        source:onceDataInfo.source,
        coverImg:onceDataInfo.coverImg,
        url:`/policy/${onceDataInfo.coverImg}`,
        target:onceDataInfo.target,
        startTime:onceDataInfo.startTime,
        endTime:onceDataInfo.endTime,
    };


    return {dataInfo:result};
}


/**
 * 删除资讯信息
 * @param id 标识
 * @returns 
 */
export async function deleteOnceInformationDate(id:string) {
    let onceDataInfo = await activityData.selectActivityDataById(id);

    if (onceDataInfo.state) throw new BizError(ERRORENUM.请先关闭该资讯, "未关闭资讯进行删除操作");

    await activityData.deleteActivityData(id);

    return {isSuccess:true};
}


/**
 * 修改资讯信息
 * @param id 标识 
 * @param desc 内容
 * @param title 标题
 * @param source 来源
 * @param coverImg 图片地址
 * @returns 
 */
export async function updateOnceInformation(id:string, desc:string, title:string ,source:string, coverImg:string, startTime, endTime, target) {
    let onceDataInfo = await activityData.selectActivityDataById(id);

    if (onceDataInfo.state) throw new BizError(ERRORENUM.请先关闭该资讯, "未关闭资讯进行修改操作");

    onceDataInfo.coverImg = coverImg;
    onceDataInfo.title = title;
    onceDataInfo.desc = desc;
    onceDataInfo.source = source;

    onceDataInfo.startTime = startTime;
    onceDataInfo.endTime = endTime;
    onceDataInfo.target = target;

    await onceDataInfo.save();

    return {isSuccess:true};
}


/**
 * 查询资讯列表
 * @param selectTitle 标题
 * @param createTime 创建时间
 * @param state 状态
 * @param page 分页
 * @returns 
 */
export async function selectInformation(selectTitle:string, createTime:number, state:number, target, page:number) {

    let selectParam:any = {};
    if (state == 2 || state == 3) {
        if (state == 2) {
            selectParam = {state:true, "$or":[{closeTimeMs: {"$gt":new Date().valueOf()} }, {isPermanent:true}] };
        } else {
            selectParam = {"$or":[{closeTimeMs: {"$lt":new Date().valueOf()} }, {state:false}] };
        }
    }
    if (selectTitle) {
        selectParam["title"] =  {"$regex":`${selectTitle}`};
    }
    if (createTime) {
        selectParam["$and"] = [{"createTimeMs":{"$gt":createTime }}, {"createTimeMs":{"$lt":createTime+(3600*26*1000) }}]
    }
    if (target) {
        selectParam.target = {"$in":[target]}
    }

    let dataBaseList = await activityData.selectActivityByParamToPage(selectParam, (page-1)* 10);
    let count = await activityData.selectActivityyParamCount(selectParam);
    let pageCount = count ? Math.ceil(count/10) : 0;

    let dataList = [];
    dataBaseList.forEach(info => {
        let {title, createTimeMs, state, closeTimeMs, isPermanent, id} = info;
        let stateStr = "下线";
        if (state) {
            stateStr = "上线";
            if (!isPermanent && closeTimeMs< new Date().valueOf()) stateStr = "下线";
        }

        dataList.push({
            id,
            title,
            createTime:moment(createTimeMs).format("YYYY-MM-DD"),
            state,
            stateStr,
            target:changeEnumManyValue(VISITDEMAND, info.target)
        });
    });

    return {dataList, pageCount, count};
}



export async function selectInfoEnterprise(id:string ) {
    let onceDataInfo = await activityData.selectActivityDataById(id);

    if (!onceDataInfo) throw new BizError(ERRORENUM.目标数据不存在, "目标数据不存在");


    let demandList = await demandData.findByParam({demand:{"$in":onceDataInfo.target}})

    let dataList = [];
    demandList.forEach(info => {
        dataList.push({enterpriseName:info.enterpriseName, demand:info.demand});
    });

    return {dataList};
}
