/**
 * 公共资源路由
 */

import * as asyncHandler from 'express-async-handler';
import { FUHUAQILV, INSTITUTIONALNATURE, FUHUAINDUSTRY, INDUSTRY } from '../config/enum';
import { checkToken } from '../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/public/fuhuaqilv', checkToken, asyncHandler(getFuHuaQiLv));
    httpServer.post('/public/institutionalnature', checkToken, asyncHandler(getInstitutionalNature));
    httpServer.post('/public/fuhuaqiindustry', checkToken, asyncHandler(getFuHuaQiIndustry));
    httpServer.post('/public/industry', checkToken, asyncHandler(getIndustry));
}

/**
 * 获取孵化器等级列表
 * @param req 
 * @param res 
 */
async function getFuHuaQiLv(req, res) {
    let lvList = [];
    for (let key in FUHUAQILV) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:FUHUAQILV[key]});
        }
    }
    res.success({lvList});
}


/**
 * 获取孵化器机构性质列表
 * @param req 
 * @param res 
 */
async function getInstitutionalNature(req, res) {
    let lvList = [];
    for (let key in INSTITUTIONALNATURE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:INSTITUTIONALNATURE[key]});
        }
    }
    res.success({lvList});
}

/**
 * 获取孵化器领域
 * @param req 
 * @param res 
 */
async function getFuHuaQiIndustry(req, res) {
    let lvList = [];
    for (let key in FUHUAINDUSTRY) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:FUHUAINDUSTRY[key]});
        }
    }
    res.success({lvList});
}

/**
 * 获取行业领域
 * @param req 
 * @param res 
 */
async function getIndustry(req, res) {
    let lvList = [];
    for (let key in INDUSTRY) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            lvList.push({key, value:INDUSTRY[key]});
        }
    }
    res.success({lvList});
}
