/**
 * 小程序端孵化器的路由入口
 */
import * as asyncHandler from 'express-async-handler';
import * as userBiz from '../biz/fuHuqQi/user';
import * as baseBiz from '../biz/fuHuqQi/base';
import * as taskBiz from '../biz/fuHuqQi/task';
import * as monthBiz from '../biz/fuHuqQi/month';
import * as enterpriseBiz from '../biz/enterprise/enterprise';
import * as financingBiz from '../biz/enterprise/financing';
import { checkReqParam } from '../util/tools';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/login', asyncHandler(login));
    /**基础数据 */
    httpServer.post('/fuhuaqi/base', asyncHandler(baseInfo));
    httpServer.post('/fuhuaqi/mydata', asyncHandler(myDataInfo));
    httpServer.post('/fuhuaqi/base/update', asyncHandler(updateMyDataInfo));
    /**任务 */
    httpServer.post('/fuhuaqi/task/list', asyncHandler(taskList));
    httpServer.post('/fuhuaqi/task/submit', asyncHandler(submitTask));
    /**月度报表 */
    httpServer.post('/fuhuaqi/month/addreport', asyncHandler(addReport));
    httpServer.post('/fuhuaqi/month/updatereport', asyncHandler(updateReport));
    httpServer.post('/fuhuaqi/month/deletereport', asyncHandler(deleteReport));

    /**融资企业填报 */
    httpServer.post('/fuhuaqi/financing/create', asyncHandler(createFinancingInfo));
    httpServer.post('/fuhuaqi/financing/update', asyncHandler(updateFinancingInfo));

    /**新注册或迁入企业 */
    httpServer.post('/fuhuaqi/enterprise/register', asyncHandler(registerEnterprise));
    httpServer.post('/fuhuaqi/enterprise/updateregister', asyncHandler(updateRegisterEnterprise));
    httpServer.post('/fuhuaqi/enterprise/move', asyncHandler(moveInEnterprise));
    httpServer.post('/fuhuaqi/enterprise/updatemove', asyncHandler(updateMoveInEnterprise));
}

/**
 * 创建企业融资信息 
 * @param req 
 * @param res 
 */
 async function createFinancingInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await financingBiz.createFinancingInfo(Uscc, form);
    res.success(result);
}

/**
 * 更新融资企业信息 
 * @param req 
 * @param res 
 */
 async function updateFinancingInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await financingBiz.updateFinancingInfo(Uscc, form);
    res.success(result);
}

/**
 * 新注册企业 
 * @param req 
 * @param res 
 */
async function registerEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.registerEnterprise(Uscc, form);
    res.success(result);
}

/**
 * 新注册企业表单修改 
 * @param req 
 * @param res 
 */
async function updateRegisterEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.updateRegisterEnterprise(Uscc, form);
    res.success(result);
}

/**
 * 迁入企业登记 
 * @param req 
 * @param res 
 */
 async function moveInEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.moveInEnterprise(Uscc, form);
    res.success(result);
}

/**
 * 修改迁入企业登记信息 
 * @param req 
 * @param res 
 */
 async function updateMoveInEnterprise(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await enterpriseBiz.updateMoveInEnterprise(Uscc, form);
    res.success(result);
}

//=======================

/**
 * 孵化器登录 
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {uscc:'String', pwd:'String'};
    let {uscc, pwd} = checkReqParam(reqConf, req.body);
    
    let result = await userBiz.login(uscc, pwd);

    res.success(result);
}


/**
 * 主界面信息 
 * 包括首页的 我的数据 评分明细
 * @param req 
 * @param res 
 */
async function baseInfo(req, res) {
    const Uscc = req.headers.uscc;

    let userInfo = await baseBiz.homeData(Uscc);

    res.success(userInfo);
}

/**
 * 我的数据 详细数据
 * @param req 
 * @param res 
 */
async function myDataInfo(req, res) {
    const Uscc = req.headers.uscc;

    let userInfo = await baseBiz.selectFuHuaQiBaseData(Uscc);

    res.success(userInfo);
}


/**
 * 任务列表
 * @param req 
 * @param res 
 */
async function taskList(req, res) {
    const Uscc = req.headers.uscc;

    let result = await taskBiz.fuHuaQiTaskList(Uscc);

    res.success(result);
}


/**
 * 提交任务
 * @param req 
 * @param res 
 */
async function submitTask(req, res) {
    let reqConf = {taskType:'Number'};
    let { taskType } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await taskBiz.checkTask(Uscc, taskType);
    res.success(result);
}


/**
 * 更新基础数据
 * @param req 
 * @param res 
 */
async function updateMyDataInfo(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await baseBiz.updateFuHuaQiBaseData(Uscc, form);
    res.success(result);
}

/**
 * 孵化器月度填报 新增报表
 * @param req 
 * @param res 
 */
async function addReport(req, res) {
    let reqConf = {occupancyRate: 'Number' };
    let { occupancyRate } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let monthInfo = monthBiz.createReport(Uscc, occupancyRate);
    res.success(monthInfo);
}

/**
 * 孵化器月度填报  删除报表
 * @param req 
 * @param res 
 */
async function deleteReport(req, res) {
    const Uscc = req.headers.uscc;

    let monthInfo = monthBiz.deleteReport(Uscc);
    res.success(monthInfo);
}

/**
 * 孵化器月度填报 修改报表
 * @param req 
 * @param res 
 */
async function updateReport(req, res) {
    let reqConf = {occupancyRate: 'Number' };
    let { occupancyRate } = checkReqParam(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let monthInfo = monthBiz.updateReport(Uscc, occupancyRate);
    res.success(monthInfo);
}