/**
 * 孵化器月度填报表 
 * draftLock 草稿锁 当任务提交的时候，将此字段改为true
 * occupancyRate 取%号前的数据 例如 填报数据为80%  库中数据为80
 * name 为系统生成 此月填报上一月内容 即2月填报时 name中月份为1月  2023-02-06 确定此需求
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const monthTableSchema = new Schema({
    taskId:String,//任务id
    name:String,//任务名称
    fuHuaQiUscc:String,//任务所属孵化器id
    occupancyRate:Number,//出租率 单位为% 
    createTime:Number,//创建时间
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
});

var monthTableModel;
export function initModel(){
    monthTableModel = baseDB.model('monthTable', monthTableSchema);
    monthTableModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await monthTableModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

/**
 * 通过taskId 获取此次任务添加的月度列表
 * @param taskId 任务id 格式遵循tool中getTaskId
 * @returns {}
 */
export async function findmonthTableListByTaskId(taskId:string) {
    return await monthTableModel.find({taskId}).exec();
}

/**
 * 通过taskId 获取此次月度任务
 * 支持.save方法保存对象修改
 * @param taskId 任务id 格式遵循tool中getTaskId
 * @returns {}
 */
export async function findmonthTableByTaskId(taskId:string) {
    let monthTableInfo = await monthTableModel.selectOnceData({taskId}).exec();
    return monthTableInfo;
}

/**
 * 孵化器月度填报 新增报表
 * @param name 任务名称 系统生成
 * @param uscc 孵化器统一信用代码
 * @param occupancyRate 出租率
 * @param createTime 创建时间
 * 
 */
export async function addOnceReport(name:string, uscc:string, occupancyRate:number) {
    let monthInfo = {name, fuHuaQiUscc:uscc, occupancyRate, createTime:new Date().valueOf()}
    await monthTableModel.create(monthInfo);
}

/**
 * 孵化器月度填报 删除报表
 * @param uscc 孵化器统一信用代码
 */
export async function deleteReport(uscc:string) {
    return await monthTableModel.remove({fuHuaQiUscc:uscc}).exec();
}