/**
 * 孵化器信息表
 * operationName不可修改 2023-02-06 确定此需求
 * uscc不可修改 2023-02-06 确定此需求
 * 首次登录要求改密码 不改密码不能继续操作 2023-02-07 确定此需求
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const fuHuaQiSchema = new Schema({
    name: {type:String,index: true},//名称
    pwd:String,//登录密码
    firstLoginIsChangePwd:{type:Boolean, default:false},//首次登录是否修改密码
    operationName:String,//运营机构名称  不可修改
    uscc:{type:String, index: true},//统一信用代码 也是登录账号 不可修改
    virtualEnterpriseNum:Number,//虚拟企业数量
    logonTime:Number,//注册时间
    incubatedAcreage:Number,//在孵面积(㎡)
    acreageTotal:Number,//孵化器总面积(㎡)
    acreagePersonalUse:Number,//孵化器自用面积(㎡)
    lv:Number,//孵化器级别
    identificationTime:Number,//认定时间
    industry:[Number],//领域
    institutionalNature:Number,//机构性质
    liaison:String,//联系人
    liaisonPhone:String,//联系电话
    personInCharge:String,//负责人
    personInChargePhone:String,//负责人联系电话
    personInChargeAdd:String,//孵化场地地址
    siteAcreage:Number,//孵化场地面积(㎡)
    leasePrice:Number//孵化场地出租单价
});

var fuHuaQiModel;
export function initModel(){
    fuHuaQiModel = baseDB.model('fuhuaqi', fuHuaQiSchema);
    fuHuaQiModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await fuHuaQiModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

/**
 * 通过统一信用代码获取孵化器信息
 * 支持.save方法保存对象修改
 * @param uscc 孵化器统一信用代码
 * @returns {}
 */
export async function findFuHuaQiByUSCC(uscc:string) {
    return await fuHuaQiModel.selectOnceData({uscc}).exec();
}

/**
 * 通过孵化器名称获取孵化器信息
 * @param name 孵化器名称
 * @returns {}
 */
export async function findFuHuaQiByName(name:string) {
    return await fuHuaQiModel.findOne({name}).exec();
}

/**
 * 通过信用代码获取孵化器信息
 * @param uscc 信用代码
 * @returns 信用代码为uscc的孵化器信息
 */
export async function findFuHuaQiByUscc(uscc:string) {
    return await fuHuaQiModel.findOne({uscc}).exec();
}