/**
 * 企业信息表
 * draftLock 草稿锁 当任务提交的时候，将此字段改为true
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../db/dbInit';

const enterpriseSchema = new Schema({
    name: {type:String, index: true},//企业名称
    taskId:{type:String, index:true},//绑定的任务id
    uscc:{type:String, index: true},//统一信用代码
    fuHuaQiUscc:{type:String, index:true},//孵化器统一信用代码
    industry:[Number],//领域
    logonTime:Number,//注册时间
    firstIncubationTime:Number,//首次入孵时间
    timeOfImmigration:Number,//迁入时间
    isNaturalPersonHolding:{type:Boolean, default:true},//是否自然人控股企业
    oldLogonAdd:String,//迁入前注册地址
    logonAdd:String,//注册地址
    operatingAdd:String,//经营地址
    // isPhysicalPresence:{type:Boolean, default:true},//是否实地孵化 暂时弃用
    leasedArea:Number,//租赁面积（平方米）
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
    createTime:Number,//录入时间
});

var enterpriseModel;
export function initModel(){
    enterpriseModel = baseDB.model('enterprise', enterpriseSchema);
    enterpriseModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await enterpriseModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

/**
 * 通过taskId 获取此次任务添加的企业列表
 * @param taskId 任务id 格式遵循tool中getTaskId
 * @returns [{}]
 */
export async function findEnterpriseListByTaskId(taskId:string) {
    return await enterpriseModel.find({taskId}).exec();
}


/**
 * 将taskId的所有数据的draftLock字段为true
 * @param taskId 任务id 格式遵循tool中getTaskId
 */
export async function updateEnterpriseDraftLock(taskId:string) {
    return await enterpriseModel.update({taskId}, {$set:{draftLock:true}}, {upsert:true});
}

/**
 * 通过企业统一信用代码获取企业信息
 * 支持.save方法保存对象修改
 * @param uscc 企业统一信用代码
 * @returns {}
 */
export async function findEnterpriseByUscc(uscc:string) {
    return await enterpriseModel.selectOnceData({uscc}).exec();
}

/**
 * 创建新的企业数据
 * @param fuHuaQiUscc 企业所属孵化器的统一信用代码
 * @param taskId 任务id 格式遵循tool中getTaskId
 * @param param 添加的字段对象
 */
export async function createEnterprise(fuHuaQiUscc:string, taskId:string, param) {
    let addInfo = Object.assign({fuHuaQiUscc, taskId, createTime:new Date().valueOf()}, param);
    await enterpriseModel.create(addInfo);
}


/**
 * 查找孵化器所拥有的企业数量
 * @param fuHuaQiUscc 孵化器统一信用代码
 * @returns 
 */
export async function findEnterpriseCountByFuHuaQiUscc(fuHuaQiUscc:string) {
    return await enterpriseModel.count({fuHuaQiUscc}).exec();
}
