/**
 * 校验参数所用的配置
 * 
 */

/**
 * 更新孵化器基础数据的表单配置
 */
export const BaseParamUpdateConfig = {
    name:"String",
    virtualEnterpriseNum:"Number",
    logonTime:"Number",
    incubatedAcreage:"Number",
    acreageTotal:"Number",
    acreagePersonalUse:"Number",
    lv:"Number",
    identificationTime:"Number",
    industry:"[Number]",
    institutionalNature:"Number",
    liaison:"String",
    liaisonPhone:"String",
    personInCharge:"String",
    personInChargePhone:"String",
    personInChargeAdd:"String",
    siteAcreage:"Number",
    leasePrice:"Number"
};


/**
 * 新注册企业的表单配置
 */
export const RegisterEnterpriseParamConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    logonAdd:"String",//注册地址
    operatingAdd:"String",//经营地址
    leasedArea:"Number",//租赁面积（平方米）
};


/**
 * 迁入企业登记表单配置
 */
export const MoveInEnterpriseParamConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    timeOfImmigration:"Number",//迁入时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    oldLogonAdd:"String",//迁入前注册地址
    logonAdd:"String",//注册地址
    operatingAdd:"String",//经营地址
    leasedArea:"Number",//租赁面积（平方米）
};


/**
 * 融资企业登记表单配置
 */
export const FinancingParamConfig = {
    uscc:"String", //统一信用代码
    name:"String",//企业名称
    taskId:"String", //任务id
    logonAdd:"String",//注册地址
    operatingAdd:"String",//经营地址
    financingTime:"Number",//获得融资时间
    financingAmount:"Number",//融资金额(万元)
    investmentInstitutionsName:"String",//投资机构名称
    timeToObtainInvestment:"Number",//获得投资时间
    fuHuaQiInvestment:"Boolean", //孵化器是否投资
    fuHuaQiInvestmentAmount:"Number",//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:"Number",//孵化器投资方式

};
