/**
 * 孵化器用户逻辑层 
 * 作者: 陈金晶
 * 主要包括有 孵化器账号的登录 
 * 预留好  重置密码  退出登录 接口  
 */
import { ERRORENUM } from "../../config/errorEnum";
import * as fuhuaqiData from "../../data/fuHuaQi/fuhuaqi"
import { BizError } from "../../util/bizError";
import { getPwdMd5 } from "../../util/tools";

/**
 * 登录
 * @param uscc 信用代码
 * @param pwd 密码
 * @returns fuhuaqiUserInfo:{uscc, name} 登录后的信息
 */
export async function login(uscc:string, pwd:string) {
    let fuhuaqiInfo = await fuhuaqiData.findFuHuaQiByUscc(uscc);
    if(!fuhuaqiInfo) throw new BizError(ERRORENUM.未找到数据);

    let checkPwd = getPwdMd5(fuhuaqiInfo.uscc, pwd);
    if (fuhuaqiInfo.pwd != checkPwd) throw new BizError(ERRORENUM.密码错误);
    let fuhuaqiUserInfo = {
        uscc: fuhuaqiInfo.uscc,
        name: fuhuaqiInfo.name
    };
    
    return fuhuaqiUserInfo;
}


/**
 * 首次登录修改密码
 * @param uscc 孵化器统一信用代码
 * @param pwd 新密码p
 * @param confirmPwd 确认密码 
 * @returns 
 */
export async function firstLoginChangePwd(uscc:string, pwd:string, confirmPwd:string ) {
    let dataBaseInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);
    if (dataBaseInfo.firstLoginIsChangePwd) throw new BizError(ERRORENUM.不能重复修改密码, `重复调用了首次登录之后的修改密码接口${uscc}`);
    //todo 校验密码
    dataBaseInfo.pwd = pwd;
    await dataBaseInfo.save();

    return {isSuccess:true};
}


/**
 * 重置密码
 * @param uscc 信用代码
 * @param pwd 原密码
 * @param newPwd 修改后的密码
 * @returns {isSuccess:true/false}
 */
export async function changePassword(uscc:string, pwd:string, newPwd:string) {
    let reg = new RegExp("[`~!@#$^&*()=|{}':;',\\[\\].<>/?~！@#￥……&*（）——|{}【】‘；：”“'。，、？]");
    if (reg.test(newPwd)) {
        throw new BizError(ERRORENUM.密码不允许有特殊字符);
    }
    let fuhuaqiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);
    if (!fuhuaqiInfo) throw new BizError(ERRORENUM.未找到数据);
    let checkPwd = getPwdMd5(fuhuaqiInfo.uscc, pwd);
    if (fuhuaqiInfo.pwd != checkPwd) throw new BizError(ERRORENUM.密码错误);
    fuhuaqiInfo.pwd = getPwdMd5(uscc, newPwd);
    await fuhuaqiInfo.save();

    return {isSuccess:true};
}

/**
 * 退出登录
 * @param uscc 信用代码
 * @returns {isSuccess:true/false}
 */
export async function logout(uscc:string):Promise<object> {
    if (typeof uscc != "string") throw new BizError(ERRORENUM.参数错误, uscc);
    let fuhuaqiInfo = await fuhuaqiData.findFuHuaQiByUSCC(uscc);
    await fuhuaqiInfo.save();
    return {isSuccess:true};
}