/**
 * 月度表单逻辑层 
 * 作者: 陈金晶
 * 月度表单相关逻辑 包括孵化器月度填报的增删改查
 */
import { ERRORENUM } from "../../config/errorEnum";
import { BizError } from "../../util/bizError";
import * as monthData from "../../data/fuHuaQi/monthTable";
import { getTaskId } from "../../util/tools";
import moment = require("moment");

/**
 * 新添加孵化器月度填报
 * @param uscc 孵化器的统一信用代码
 * @param occupancyRate 本月出租率
 * @returns {isSuccess:true/false}
 */
export async function createReport(uscc:string, occupancyRate:number) {
    //不允许有重复的
    const TaskId = getTaskId(uscc);
    let dataBaseInfo = await monthData.findmonthTableListByTaskId(TaskId);

    if (!dataBaseInfo || !dataBaseInfo.taskId) throw new BizError(ERRORENUM.该孵化器月度填报已存在, `${uscc}重复提交了月度填报值为${occupancyRate}`);

    const MonthNumber = moment().subtract(1, 'months').month() + 1;
    const MonthTableName = `${MonthNumber}月孵化器月度填报`;
    await monthData.addOnceReport(MonthTableName, uscc, occupancyRate);
    
    return {isSuccess:true};
}

/**
 * 修改孵化器月度报表
 * @param uscc 孵化器的统一信用代码
 * @param occupancyRate 本月出租率
 * @returns {isSuccess:true/false}
 */
export async function updateReport(uscc:string, occupancyRate:number) {
    const TaskId = getTaskId(uscc);
    let dataBaseInfo = await monthData.findmonthTableListByTaskId(TaskId);
    if (dataBaseInfo || dataBaseInfo.taskId) throw new BizError(ERRORENUM.未找到数据, `未找到${uscc}的月度报表` );
    
    dataBaseInfo.occupancyRate = occupancyRate;
    await dataBaseInfo.save();

    return {isSuccess:true};
}

/**
 * 删除孵化器月度报表
 * @param uscc 孵化器的统一信用代码
 * @returns  {isSuccess:true/false}
 */
export async function deleteReport(uscc:string) {
    const TaskId = getTaskId(uscc);
    let dataBaseInfo = await monthData.findmonthTableListByTaskId(TaskId);
    if (dataBaseInfo || dataBaseInfo.taskId) throw new BizError(ERRORENUM.未找到数据);

    await monthData.deleteReport(uscc);

    return {isSuccess:true};
}