/**
 * 孵化器基础数据相关逻辑
 * 作者: 李某
 * 孵化器相关逻辑 包括孵化器的增删改查
 * 
 */
import { BaseParamUpdateConfig } from "../../config/checkParamConfig";
import { findEnterpriseCountByFuHuaQiUscc } from "../../data/enterprise/enterprise";
import { findFuHuaQiByUSCC } from "../../data/fuHuaQi/fuhuaqi";
import * as tools from "../../util/tools";


/**
 * 更新孵化器基础数据
 * @param uscc 孵化器统一信用代码
 * @param param 表单内容
 * @returns {isSuccess:true/false};
 */
export async function updateFuHuaQiBaseData(uscc:string, param) {
    let baseDataInfo = await findFuHuaQiByUSCC(uscc);
    
    tools.checkParamater("更新孵化器基础数据", BaseParamUpdateConfig, param);
    
    let changeList = tools.checkChange(param, baseDataInfo);
    for (let i = 0; i < changeList.length; i++) {
        let key = changeList[i];
        baseDataInfo[key] = param[key];
    }

    await baseDataInfo.save();

    return {isSuccess:true};
}


/**
 * 查询孵化器基础数据
 * @param uscc 孵化器统一信用代码
 * @returns data 基础数据字段
 */
export async function selectFuHuaQiBaseData(uscc:string) {
    let dataBaseInfo = await findFuHuaQiByUSCC(uscc);

    let keyList = [ 
        "name", "operationName", "uscc", "virtualEnterpriseNum", "logonTime", "incubatedAcreage", "acreageTotal", "acreagePersonalUse", 
        "lv", "identificationTime","industry","institutionalNature","liaison","liaisonPhone","personInCharge","personInChargePhone",
        "personInChargeAdd","siteAcreage","leasePrice"];
    let data = {};

    keyList.forEach( key => {
        data[key] = dataBaseInfo[key];
    });

    return data;
}

/**
 * 主界面基础数据
 * @param uscc 孵化器统一信用代码
 * @returns data "incubatedAcreage", "acreageTotal", "acreagePersonalUse", "enterpriseCount"
 */
export async function homeData(uscc:string) {
    let dataBaseInfo = await findFuHuaQiByUSCC(uscc);
    let keyList = [ "incubatedAcreage", "acreageTotal", "acreagePersonalUse"];
    let data:any = {enterpriseCount:0};

    keyList.forEach( key => {
        data[key] = dataBaseInfo[key];
    });

    data.enterpriseCount  = await findEnterpriseCountByFuHuaQiUscc(uscc);
    
    return data;
}