/**
 * 企业融资相关逻辑
 * 作者: 李欣鸣
 * 包括新融资信息的增删改查
 * 
 */

import { FinancingParamConfig } from "../../config/checkParamConfig";
import { ERRORENUM } from "../../config/errorEnum";
import { createFinancing, findFinancingInfoByTaskIdAndSucc } from "../../data/enterprise/financing";
import { BizError } from "../../util/bizError";
import { checkChange, checkParamater, getTaskId } from "../../util/tools";


/**
 * 创建企业融资信息
 * @param uscc 孵化器统一信用代码
 * @param param 表单配置
 * @returns {isSuccess:true/false}
 */
export async function createFinancingInfo(uscc, param) {
    const TaskId = getTaskId(uscc);

    checkParamater("录入企业融资信息", FinancingParamConfig, param);

    let dataBaseInfo = await findFinancingInfoByTaskIdAndSucc(TaskId, param.uscc);
    
    if ( dataBaseInfo&& dataBaseInfo.uscc)  throw new BizError(ERRORENUM.该企业当月数据已存在, `${param.uscc}的融资信息已经存在`);

    await createFinancing(uscc, TaskId, param);

    return {isSuccess:true};
}

/**
 * 更新融资企业信息
 * @param uscc 孵化器统一信用代码
 * @param param 表单配置
 * @returns {isSuccess:true/false}
 */
export async function updateFinancingInfo(uscc, param) {
    const TaskId = getTaskId(uscc);

    checkParamater("录入企业融资信息", FinancingParamConfig, param);
    let dataBaseInfo = await findFinancingInfoByTaskIdAndSucc(TaskId, param.uscc);
    let changeList = checkChange(param, dataBaseInfo);

    if (!dataBaseInfo || !dataBaseInfo.uscc) throw new BizError(ERRORENUM.未找到数据, `库中不存在${TaskId}的任务`);
    if ( !changeList.length ) throw new BizError(ERRORENUM.数据无更新, `${param.uscc}数据无更新`);

    changeList.forEach(key => {
        dataBaseInfo[key] = param[key];
    });

    await dataBaseInfo.save();

    return {isSuccess:true};
}
