/**
 * 企业相关逻辑
 * 作者: 李欣鸣
 * 包括新注册企业，迁入企业
 * 
 */

import { MoveInEnterpriseParamConfig, RegisterEnterpriseParamConfig } from "../../config/checkParamConfig";
import { ERRORENUM } from "../../config/errorEnum";
import { createEnterprise, findEnterpriseByUscc } from "../../data/enterprise/enterprise";
import { BizError } from "../../util/bizError";
import { checkChange, checkParamater, getTaskId } from "../../util/tools"


/**
 * 新注册企业
 * @param uscc 孵化器统一信用代码
 * @param param 表单参数
 * @returns {isSuccess:true/false}
 */
export async function registerEnterprise(uscc:string, param) {
    const TaskId = getTaskId(uscc);
    checkParamater("新注册企业", RegisterEnterpriseParamConfig, param);
    let dataBaseInfo = await findEnterpriseByUscc(param.uscc);
    
    if ( dataBaseInfo&& dataBaseInfo.uscc)  throw new BizError(ERRORENUM.该企业已存在, `${param.uscc}已经在库中存在`);

    await createEnterprise(uscc, TaskId, param);

    return {isSuccess:true};
}


/**
 * 新注册企业表单修改
 * @param uscc 孵化器统一信用代码
 * @param param 表单参数
 * @returns {isSuccess:true/false}
 */
export async function updateRegisterEnterprise(uscc:string, param) {
    checkParamater("新注册企业表单修改", RegisterEnterpriseParamConfig, param);
    let dataBaseInfo = await findEnterpriseByUscc(param.uscc);
    
    if (!dataBaseInfo || !dataBaseInfo.uscc) throw new BizError(ERRORENUM.未找到数据, `库中不存在${param.uscc}这个企业`);

    let changeList = checkChange(param, dataBaseInfo);
    if ( !changeList.length ) throw new BizError(ERRORENUM.数据无更新, `${param.uscc}数据无更新`);

    changeList.forEach(key => {
        dataBaseInfo[key] = param[key];
    });

    await dataBaseInfo.save();

    return {isSuccess:true};
}


/**
 * 迁入企业登记
 * @param uscc 孵化器统一信用代码
 * @param param 表单参数
 * @returns {isSuccess:true/false}
 */
export async function moveInEnterprise(uscc:string, param) {
    const TaskId = getTaskId(uscc);
    checkParamater("迁入企业登记", MoveInEnterpriseParamConfig, param);
    let dataBaseInfo = await findEnterpriseByUscc(param.uscc);
    
    if ( dataBaseInfo&& dataBaseInfo.uscc)  throw new BizError(ERRORENUM.该企业已存在, `${param.uscc}已经在库中存在`);

    await createEnterprise(uscc, TaskId, param);

    return {isSuccess:true};
}


/**
 * 修改迁入企业登记信息
 * @param uscc 孵化器统一信用代码
 * @param param 表单参数
 * @returns {isSuccess:true/false}
 */
export async function updateMoveInEnterprise(uscc:string, param) {
    checkParamater("修改迁入企业登记信息", MoveInEnterpriseParamConfig, param);
    let dataBaseInfo = await findEnterpriseByUscc(param.uscc);
    
    if (!dataBaseInfo || !dataBaseInfo.uscc) throw new BizError(ERRORENUM.未找到数据, `库中不存在${param.uscc}这个企业`);


    let changeList = checkChange(param, dataBaseInfo);
    if ( !changeList.length ) throw new BizError(ERRORENUM.数据无更新, `${param.uscc}数据无更新`);

    changeList.forEach(key => {
        dataBaseInfo[key] = param[key];
    });

    await dataBaseInfo.save();

    return {isSuccess:true};
    
}

