/**
 * 管理后台端 企业相关 
 * 包括 在孵企业页面
 * 包括 企业融资页面 
 */

import * as asyncHandler from 'express-async-handler';
import * as enterpriseAdminBiz from '../../biz/admin/enterprise/enterprise';
import * as financingAdminBiz from '../../biz/admin/enterprise/financing';
import { getTimeKey } from '../../tools/system';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';


export function setRouter(httpServer) {
    httpServer.post('/admin/enterprise/list',checkGuanWeiHuiToken, asyncHandler(getEnterpriseList));
    httpServer.post('/admin/enterprise/financinglist',checkGuanWeiHuiToken, asyncHandler(getFinancingList));
    httpServer.post('/admin/enterprise/affiliationfuhuaqi',checkGuanWeiHuiToken,asyncHandler(affiliationFuHuaQi));
    httpServer.post('/admin/data/output/enterprise',checkGuanWeiHuiToken, asyncHandler(outPutEnterpriseData));
    httpServer.post('/admin/data/output/financing',checkGuanWeiHuiToken, asyncHandler(outPutFinancingData));
    /**迁出企业2.0新加 */
    httpServer.post('/admin/enterprise/moveoutlist',checkGuanWeiHuiToken, asyncHandler(moveOutList));
    httpServer.post('/admin/data/output/moveoutlist',checkGuanWeiHuiToken, asyncHandler(outPutMoveOutList));
    
}


/**
 * 后台管理 获取在孵企业信息列表 
 * @param req 
 * @param res 
 */
async function getEnterpriseList(req, res) {
    let reqConf = {name:'String', createType: 'Number', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', state:'Number', createTime:'Number', page: 'Number' };
    const NotMustHaveKeys = ["createType", "fuHuaQiUscc", "industry", "isNaturalPersonHolding", "state", "createTime", "name"];
    
    let { createType, fuHuaQiUscc, industry, isNaturalPersonHolding, state, createTime, name, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    let result = await enterpriseAdminBiz.enterpriseList(createType, fuHuaQiUscc, industry, isNaturalPersonHolding, state, createTime, name, page);
    res.success(result);
}


/**
 * 后台管理 获取融资企业信息列表 
 * @param req 
 * @param res
 */
async function getFinancingList(req, res) {
    let reqConf = {monthData: 'String', fuHuaQiName: 'String', fuHuaQiInvestment: 'Number', industry: '[Number]', page: 'Number' };
    const NotMustHaveKeys = ["monthData", "fuHuaQiName", "fuHuaQiInvestment", "industry" ];
    let {monthData, fuHuaQiName, industry, fuHuaQiInvestment, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await financingAdminBiz.financingList(monthData, fuHuaQiName, industry, fuHuaQiInvestment, page);
    res.success(result);
}


/**
 * 所属孵化器
 * 下拉框
 * @param req 
 * @param res 
 */
async function affiliationFuHuaQi(req, res) {
    let  result = await enterpriseAdminBiz.getAffiliationFuHuaQi();
    res.success(result);
}


/**
 * 导出在孵企业数据
 * @param req 
 * @param res 
 */
async function outPutEnterpriseData(req, res) {
    let reqConf = {name:'String', createType: 'Number', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number',  state:'Number', createTime:'Number', type:'Number' };
    const NotMustHaveKeys = ["createType", "fuHuaQiUscc", "industry", "isNaturalPersonHolding", "state", "createTime", "name" ];
    let { createType, fuHuaQiUscc, industry, isNaturalPersonHolding, type, state, createTime, name } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let dataList = await enterpriseAdminBiz.outPutEnterpriseData(createType, fuHuaQiUscc, industry, isNaturalPersonHolding, state, createTime, name, type);

    let fileName = `在孵企业${getTimeKey()}.xlsx`;

    res.success({name:fileName, data:dataList});
}


/**
 * 导出企业融资数据
 * @param req 
 * @param res 
 */
async function outPutFinancingData(req, res) {
    let reqConf = {monthData: 'String', fuHuaQiName: 'String', fuHuaQiInvestment: 'Number', industry: '[Number]', type:'Number' };
    const NotMustHaveKeys = ["monthData", "fuHuaQiName", "fuHuaQiInvestment", "industry" ];
    let {monthData, fuHuaQiName, industry, fuHuaQiInvestment, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
    
    let dataList =  await financingAdminBiz.outPutFinancingList(monthData, fuHuaQiName, industry, fuHuaQiInvestment, type);

    let name = `融资企业${getTimeKey()}.xlsx`;

    res.success({name, data:dataList});
}


/**
 * 迁出企业列表
 * 2.0
 * @param req 
 * @param res 
 */
async function moveOutList(req, res) {
    let reqConf = {name:'String', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', page: 'Number' };
    const NotMustHaveKeys = ["name", "fuHuaQiUscc", "industry", "isNaturalPersonHolding" ];
    let { name, fuHuaQiUscc, industry, isNaturalPersonHolding, page } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let restult = await enterpriseAdminBiz.enterpriseMoveOutList(name, fuHuaQiUscc, industry, isNaturalPersonHolding, page);

    res.success(restult);

}


/**
 * 导出迁出企业列表
 * 2.0
 * @param req 
 * @param res 
 */
async function outPutMoveOutList(req, res) {
    let reqConf = {name:'String', fuHuaQiUscc: 'String', industry: '[Number]', isNaturalPersonHolding: 'Number', type: 'Number' };
    const NotMustHaveKeys = ["name", "fuHuaQiUscc", "industry", "isNaturalPersonHolding" ];
    let { name, fuHuaQiUscc, industry, isNaturalPersonHolding, type } = eccReqParamater(reqConf, req.body, NotMustHaveKeys);
   
    let {dataList, fileName} = await enterpriseAdminBiz.outPutEnterpriseMoveOutList(name, fuHuaQiUscc, industry, isNaturalPersonHolding, type);

    res.success({data:dataList, name:`迁出企业${fileName}.xlsx`});

}