/**
 * 孵化器月度填报表 
 * draftLock 草稿锁 当任务提交的时候，将此字段改为true
 * occupancyRate 取%号前的数据 例如 填报数据为80%  库中数据为80
 * name 为系统生成 此月填报上一月内容 即2月填报时 name中月份为1月  2023-02-06 确定此需求
 * 
 */


import { mySqlTableClass } from "../../db/mysql/mysqlClass";

/**表结构 */
const TableConfig = {
    taskId:{type:String, index:true},//任务id
    name:String,//任务名称
    fuHuaQiUscc:String,//任务所属孵化器id
    occupancyRate:Number,//出租率 单位为% 
    createTime:Number,//创建时间
    /**不下发字段 */
    draftLock:{type:Boolean, default:false},//草稿锁，true为提交之后，false为草稿
}

/**sql */
enum SQLENUM {

}
/**多表sql */
enum MORETABLESQLENUM {

}

let financingModel;

export function initModel() {
    financingModel = new mySqlTableClass("monthTable", TableConfig, SQLENUM, MORETABLESQLENUM);
}


export async function createMonthTableToList(fuHuaQiList:object) {
    await financingModel.insertMany(fuHuaQiList);
}