import { initSMS } from "./biz/sms";
import { initSystemTask, smsTask } from "./biz/systemTask";
import { initConfig, systemConfig} from "./config/serverConfig";
import { initDB } from "./db/mongo/dbInit";
import { httpServer } from "./net/http_server";
import { initBasicData } from "./tools/dataInit";

async function lanuch() {
    /**初始化配置解析 */
    await initConfig();
    /**初始化数据库 */
    await initDB();
    /**初始化底表数据 */
    await initBasicData();
    /**初始化系统任务 */
    await initSystemTask();
    /**腾讯云短信 */
    await initSMS();
    /**创建http服务 */
    httpServer.createServer(systemConfig.port);

    // await smsTask();
    
    console.log('This indicates that the server is started successfully.');
}



lanuch();