/**
 * 校验表单参数配置
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     更新孵化器基础数据表单
 * 备注:   
 */
export const BaseParamUpdateConfig = {
    virtualEnterpriseNum:{type:"Number"},//虚拟企业数量
    incubatedAcreage:{type:"Number", notMustHave:true},//在孵面积(㎡)
    acreageTotal:{type:"Number", notMustHave:true},//孵化器总面积(㎡)
    acreagePersonalUse:{type:"Number", notMustHave:true},//孵化器自用面积(㎡)
    hatchingGround:{type:"[Object]", notMustHave:true},//经备案孵化场地
};
/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     验证经备案孵化场地
 * 备注:     当填了案孵化场地数据 验证经备案孵化场地
 */
export const BaseParamUpdateHatchingGroundConfig = {
    personInChargeAdd:{type:"String"},//孵化场地地址
    siteAcreage:{type:"Number"},//孵化场地面积(㎡)
    leasePrice:{type:"Number"},//孵化场地出租单价
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     更新孵化器机构信息数据表单
 * 备注:   
 */
export const OrganizationParamUpdateConfig = {
    name:{type:"String", notMustHave:true},// {key:"名称"},
    operationName:{type:"String"},// {key:"运营机构名称"},
    uscc:{type:"String"},// {key:"统一信用代码"},
    logonTime:{type:"Number", notMustHave:true},// {key:"注册时间", changeDate:true},
    lv:{type:"Number", notMustHave:true},// {key:"孵化器级别"},
    identificationTime:{type:"Number", notMustHave:true},// {key:"认定时间", changeDate:true},
    industry:{type:"[Number]", notMustHave:true},// {key:"孵化领域"},
    institutionalNature:{type:"Number", notMustHave:true},// {key:"机构性质"},
    operationModel:{type:"[Number]", notMustHave:true},// {key:"运营模式"},//新加
    foundingTeam:{type:"[Object]", notMustHave:true},// {key:"创始团队"},//新加
    liaison:{type:"String", notMustHave:true},// {key:"联系人"},
    liaisonPhone:{type:"String", notMustHave:true},// {key:"联系电话"},
    // personInCharge:{type:"String", notMustHave:true},// {key:"负责人"},  2.0去掉了
    // personInChargePhone:{type:"String", notMustHave:true},// {key:"负责人联系电话"},  2.0去掉了
    operationModelDes:{type:"String", notMustHave:true},//{key:"运营模式描述"},
    foundingTeamType:{type:"Number", notMustHave:true},//{key:"团队类型"}
};
/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     机构信息中的创始团队
 * 备注:     更新机构信息时 当选择了创始团队
 */
export const OrganizationParamFoundingTeamUpdateConfig = {
    memberName:{type:"String"},//成员姓名
    memberSex:{type:"Number"},//成员性别
    memberAge:{type:"Number"},//成员年龄
    memberDEGREE:{type:"Number"},//成员最高学历
    memberSchool:{type:"String"},//毕业学校
    des:{type:"String"},//履历描述
};



/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     修改新注册企业的表单
 * 备注:     全必填
 */
export const EnterpriseParamFormConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    logonAdd:"String",//注册地址
    operatingAdd:"String",//经营地址
    leasedArea:"Number",//租赁面积（平方米）
    mainBusiness:"String",//主营业务
    draftId:"String",//草稿id
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     修改新迁入企业的表单
 * 备注:     全必填
 */
export const EnterpriseInPutParamFormConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    logonAdd:"String",//注册地址
    operatingAdd:"String",//经营地址
    leasedArea:"Number",//租赁面积（平方米）
    oldLogonAdd:"String",//迁入前注册地址
    timeOfImmigration:"Number",//迁入时间
    mainBusiness:"String",//主营业务
    draftId:"String",//草稿id
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     新注册企业的表单
 * 备注:     全必填
 */ 
export const RegisterEnterpriseParamConfig = {
    name:{type:"String"}, //企业名称
    uscc:{type:"String"}, //统一信用代码
    industry:{type:"[Number]"},//领域
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAdd:{type:"String"},//注册地址
    operatingAdd:{type:"String"},//经营地址
    leasedArea:{type:"Number"},//租赁面积（平方米）
    mainBusiness:{type:"String"},//主营业务
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     迁入企业登记表单
 * 备注:     全必填
 */
export const MoveInEnterpriseParamConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    timeOfImmigration:"Number",//迁入时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    oldLogonAdd:"String",//迁入前注册地址
    logonAdd:"String",//注册地址
    operatingAdd:"String",//经营地址
    leasedArea:"Number",//租赁面积（平方米）
    mainBusiness:"String",//主营业务
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     更新融资企业登记表单
 * 备注:   
 */
export const FinancingParamUpdateConfig = {
    uscc:{type:"String"}, //统一信用代码
    name:{type:"String"},//企业名称
    logonAdd:{type:"String"},//注册地址
    operatingAdd:{type:"String"},//经营地址
    financingAmount:{type:"Number"},//融资金额(万元)
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间
    fuHuaQiInvestment:{type:"Boolean"}, //孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number", notMustHave:true},//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:{type:"Number", notMustHave:true},//孵化器投资方式
    financingRounds:{type:"Number"},//融资轮次
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     创建融资企业登记
 * 备注:     
 */
 export const FinancingParamConfig = {
    name:{type:"String"},//企业名称
    logonAdd:{type:"String"},//注册地址
    operatingAdd:{type:"String"},//经营地址
    financingAmount:{type:"Number"},//融资金额(万元)
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间
    fuHuaQiInvestment:{type:"Boolean" }, //孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number", notMustHave:true },//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:{type:"Number", notMustHave:true },//孵化器投资方式
    financingRounds:{type:"Number"},//融资轮次
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     创建融资企业登记选择了孵化器投资
 * 备注:     
 */
export const FinancingParamSubConfig = {
    fuHuaQiInvestmentAmount:{type:"Number"},
    fuHuaQiInvestmentStyle:{type:"Number"}
}


/**
 * 使用端:   管理后台
 * 场景:     新增孵化器账号
 * 备注:     所有参数为必填
 */
export const FuHuaQiUserConfig = {
    operationName:{type:"String" },//运营机构名称
    uscc:{type:"String" },//营业执照 
    personInChargePhone:{type:"String" },//负责人手机号
    personInCharge:{type:"String" }//负责人 
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     修改我的企业列表里的 我的企业信息
 * 备注:     所有参数为必填
 */
export const UpdateMyEnterpriseBaseDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAdd:{type:"String"},//注册地址
    operatingAdd:{type:"String"},//经营地址
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     我的企业列表里的 补录 迁入企业
 * 备注:     所有参数为必填
 */
export const ReplenishMyEnterpriseInPutDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAdd:{type:"String"},//注册地址
    operatingAdd:{type:"String"},//经营地址
    leasedArea:{type:"Number"},//租赁面积（平方米）
    timeOfImmigration:{type:"Number"},//迁入时间
    oldLogonAdd:{type:"String"},//迁入前注册地址
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     我的企业列表里的 补录 新注册企业
 * 备注:     所有参数为必填
 */
export const ReplenishMyEnterpriseCreateDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAdd:{type:"String"},//注册地址
    operatingAdd:{type:"String"},//经营地址
    leasedArea:{type:"Number"},//租赁面积（平方米）
}

