/**
 * 机构资质 主要逻辑
 */


import * as asyncHandler from 'express-async-handler';
import * as instiuQualifyBiz from '../../biz/mobileFuHuaQi/fuHuaQi/instituQualify/instiuQualify';
import * as i18nRegisterBiz from '../../biz/mobileFuHuaQi/fuHuaQi/instituQualify/i18nRegister';
import * as icrBiz from '../../biz/mobileFuHuaQi/fuHuaQi/instituQualify/icr';
import * as startupTeacherBiz from '../../biz/mobileFuHuaQi/fuHuaQi/instituQualify/startupTeacher';
import * as zjBeyondLayoutBiz from '../../biz/mobileFuHuaQi/fuHuaQi/instituQualify/zjBeyondLayout';
import { checkFuHuaQiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';
import { STATEENUM } from '../../config/enum';

export function setRouter(httpServer) {
    /** 国际化 */
    httpServer.post('/fuhuaqi/institutionalnature/i18n/add', checkFuHuaQiToken, asyncHandler(addRegister));
    httpServer.post('/fuhuaqi/institutionalnature/i18n/update', checkFuHuaQiToken, asyncHandler(updateRegister));
    httpServer.post('/fuhuaqi/institutionalnature/i18n/info', checkFuHuaQiToken, asyncHandler(infoRegister));
    httpServer.post('/fuhuaqi/institutionalnature/i18n/list', checkFuHuaQiToken, asyncHandler(listRegister));
    httpServer.post('/fuhuaqi/institutionalnature/i18n/delete', checkFuHuaQiToken, asyncHandler(deleteRegister));
    /**创投基金 */
    httpServer.post('/fuhuaqi/institutionalnature/ptp/info', checkFuHuaQiToken, asyncHandler(PTPInfo));
    httpServer.post('/fuhuaqi/institutionalnature/ptp/update', checkFuHuaQiToken, asyncHandler(updatePTP));
    /**技术专业平台 */
    httpServer.post('/fuhuaqi/institutionalnature/professionaltechnology/info', checkFuHuaQiToken, asyncHandler(professionalTechnologyInfo));
    httpServer.post('/fuhuaqi/institutionalnature/professionaltechnology/update', checkFuHuaQiToken, asyncHandler(updateProfessionalTechnology));
    /**入口数据概览 */
    httpServer.post('/fuhuaqi/institutionalnature/overview', checkFuHuaQiToken, asyncHandler(institutionAlnatureOverview));
    /**大学科研院所合作机构 */
    httpServer.post('/fuhuaqi/institutionalnature/icr/add', checkFuHuaQiToken, asyncHandler(addICR));
    httpServer.post('/fuhuaqi/institutionalnature/icr/update', checkFuHuaQiToken, asyncHandler(updateICR));
    httpServer.post('/fuhuaqi/institutionalnature/icr/info', checkFuHuaQiToken, asyncHandler(icrInfo));
    httpServer.post('/fuhuaqi/institutionalnature/icr/list', checkFuHuaQiToken, asyncHandler(icrList));
    httpServer.post('/fuhuaqi/institutionalnature/icr/delete', checkFuHuaQiToken, asyncHandler(deleteICR));
    /**创业导师 */
    httpServer.post('/fuhuaqi/institutionalnature/startupteacher/add', checkFuHuaQiToken, asyncHandler(addStartupTeacher));
    httpServer.post('/fuhuaqi/institutionalnature/startupteacher/update', checkFuHuaQiToken, asyncHandler(updateStartupTeacher));
    httpServer.post('/fuhuaqi/institutionalnature/startupteacher/info', checkFuHuaQiToken, asyncHandler(startupTeacherInfo));
    httpServer.post('/fuhuaqi/institutionalnature/startupteacher/list', checkFuHuaQiToken, asyncHandler(startupTeacherList));
    httpServer.post('/fuhuaqi/institutionalnature/startupteacher/delete', checkFuHuaQiToken, asyncHandler(deleteStartupTeacher));
    /**张江以外布局情况 */
    httpServer.post('/fuhuaqi/institutionalnature/zjbeyondlayout/add', checkFuHuaQiToken, asyncHandler(addZJBeyondLayout));
    httpServer.post('/fuhuaqi/institutionalnature/zjbeyondlayout/update', checkFuHuaQiToken, asyncHandler(updateZJBeyondLayout));
    httpServer.post('/fuhuaqi/institutionalnature/zjbeyondlayout/info', checkFuHuaQiToken, asyncHandler(ZJBeyondLayoutInfo));
    httpServer.post('/fuhuaqi/institutionalnature/zjbeyondlayout/list', checkFuHuaQiToken, asyncHandler(ZJBeyondLayoutList));
    httpServer.post('/fuhuaqi/institutionalnature/zjbeyondlayout/delete', checkFuHuaQiToken, asyncHandler(deleteZJBeyondLayout));
}



/**
 *  创建 国际化登记
 * @param req 
 * @param res 
 */
async function addRegister(req, res) {
    let reqConf = {country:"String", partners:"String", cMode:"String", cAchievements:"String"};
    let { country, partners, cMode, cAchievements } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await i18nRegisterBiz.createI18nRegister(Uscc, country, partners, cMode, cAchievements);

    res.success(result);

}

/**
 *  修改 国际化登记
 * @param req 
 * @param res 
 */
async function updateRegister(req, res) {
    let reqConf = {id:"String", country:"String", partners:"String", cMode:"String", cAchievements:"String"};
    let { country, partners, cMode, cAchievements, id } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await i18nRegisterBiz.updateI18nRegister(Uscc, id, country, partners, cMode, cAchievements);

    res.success(result);

}

/**
 *  回显 国际化登记
 * @param req 
 * @param res 
 */
async function infoRegister(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    let result = await i18nRegisterBiz.selectI18nRegisterInfo(id);

    res.success(result);

}

/**
 *  查询列表 国际化登记
 * @param req 
 * @param res 
 */
async function listRegister(req, res) {
    const Uscc = req.headers.uscc;

    let result = await i18nRegisterBiz.i18nRegisterListData(Uscc);

    res.success(result);

}

/**
 *  删除 国际化登记
 * @param req 
 * @param res 
 */
async function deleteRegister(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await i18nRegisterBiz.deleteI18nRegisterInfo(id);

    res.success(result);

}


/**
 * 回显 创投基金 
 * @param req 
 * @param res 
 */
async function PTPInfo(req, res) {
    const Uscc = req.headers.uscc;

    let result = await instiuQualifyBiz.getFuHuaQiPTP(Uscc);

    res.success(result);
}

/**
 * 修改 创投基金 
 * @param req 
 * @param res 
 */
async function updatePTP(req, res) {
    let reqConf = {isCreatePTP: 'Boolean', scalePTP:'Number', isParticipateInPTP:'Boolean', participatingFundCompany:'String' };
    let { isCreatePTP, scalePTP, isParticipateInPTP, participatingFundCompany } = eccReqParamater(reqConf, req.body, ["scalePTP", "isParticipateInPTP" ,"participatingFundCompany"]);
    if (isCreatePTP == STATEENUM.是) eccReqParamater(reqConf, req.body, []);

    const Uscc = req.headers.uscc;
    let result = await instiuQualifyBiz.updatePTPInfo(Uscc, isCreatePTP, scalePTP, isParticipateInPTP, participatingFundCompany);

    res.success(result);
}




/**
 * 回显 技术专业平台 
 * @param req 
 * @param res 
 */
async function professionalTechnologyInfo(req, res) {
    const Uscc = req.headers.uscc;

    let result = await instiuQualifyBiz.getProfessionalTechnology(Uscc);

    res.success(result);
}

/**
 * 修改 技术专业平台 
 * @param req 
 * @param res 
 */
async function updateProfessionalTechnology(req, res) {
    let reqConf = {
        isProfessionalTechnology:"Boolean", professionalTechnologyName:"String", 
        professionalTechnologyCreateTime:"Number", professionalTechnologyAmount:"Number", isCooperation:"Boolean", cooperationInstitutions:"String"
    };
    let skipList = ["professionalTechnologyName", "professionalTechnologyCreateTime", "professionalTechnologyAmount", "isCooperation", "cooperationInstitutions"];
    let { isProfessionalTechnology, professionalTechnologyName, professionalTechnologyCreateTime, professionalTechnologyAmount, isCooperation, cooperationInstitutions} = eccReqParamater(reqConf, req.body, skipList);
    if (isProfessionalTechnology == STATEENUM.是) eccReqParamater(reqConf, req.body, []);

    const Uscc = req.headers.uscc;
    let result = await instiuQualifyBiz.updateProfessionalTechnology(Uscc, isProfessionalTechnology, professionalTechnologyName, professionalTechnologyCreateTime, professionalTechnologyAmount, isCooperation, cooperationInstitutions);

    res.success(result);
}


/**
 *  创建 大学/科研院所合作机构
 * @param req 
 * @param res 
 */
async function addICR(req, res) {
    let reqConf = {po:"String", ce:"String", cMode:"[Number]", cAchievements:"String", startTimeMs:"Number"};
    let { po, ce, cMode, cAchievements, startTimeMs } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await icrBiz.createIcr(Uscc, po, ce, cMode, cAchievements, startTimeMs);

    res.success(result);

}

/**
 *  修改 大学/科研院所合作机构
 * @param req 
 * @param res 
 */
async function updateICR(req, res) {
    let reqConf = {id:"String", po:"String", ce:"String", cMode:"[Number]", cAchievements:"String", startTimeMs:"Number"};
    let {id, po, ce, cMode, cAchievements, startTimeMs } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await icrBiz.updateIcr(Uscc, id, po, ce, cMode, cAchievements, startTimeMs);

    res.success(result);

}

/**
 *  回显 大学/科研院所合作机构
 * @param req 
 * @param res 
 */
async function icrInfo(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    let result = await icrBiz.selectIcr(id);

    res.success(result);

}

/**
 *  查询列表 大学/科研院所合作机构
 * @param req 
 * @param res 
 */
async function icrList(req, res) {
    const Uscc = req.headers.uscc;

    let result = await icrBiz.getIcrListData(Uscc);

    res.success(result);

}

/**
 *  删除 大学/科研院所合作机构
 * @param req 
 * @param res 
 */
async function deleteICR(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await icrBiz.deleteIcr(id);

    res.success(result);

}


/**
 *  创建 创业导师
 * @param req 
 * @param res 
 */
async function addStartupTeacher(req, res) {
    let reqConf = {teacherName:"String", unit:"String", duties:"String", speciality:"[Number]", teacherLv:"Number", serviceEnterprises:"String"};
    let { teacherName, unit, duties, speciality, teacherLv, serviceEnterprises } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await startupTeacherBiz.createStartUpTeacher(Uscc, teacherName, unit, duties, speciality, teacherLv, serviceEnterprises);

    res.success(result);

}

/**
 *  修改 创业导师
 * @param req 
 * @param res 
 */
async function updateStartupTeacher(req, res) {
    let reqConf = {id:"String", teacherName:"String", unit:"String", duties:"String", speciality:"[Number]", teacherLv:"Number", serviceEnterprises:"String"};
    let {id, teacherName, unit, duties, speciality, teacherLv, serviceEnterprises } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await startupTeacherBiz.updateStartUpTeacher(Uscc, id, teacherName, unit, duties, speciality, teacherLv, serviceEnterprises);

    res.success(result);

}

/**
 *  回显 创业导师
 * @param req 
 * @param res 
 */
async function startupTeacherInfo(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    let result = await startupTeacherBiz.selectStartUpTeacher(id);

    res.success(result);

}

/**
 *  查询列表 创业导师
 * @param req 
 * @param res 
 */
async function startupTeacherList(req, res) {
    const Uscc = req.headers.uscc;

    let result = await startupTeacherBiz.getStartUpTeacherListData(Uscc);

    res.success(result);

}

/**
 *  删除 创业导师
 * @param req 
 * @param res 
 */
async function deleteStartupTeacher(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await startupTeacherBiz.deleteStartUpTeacher(id);

    res.success(result);

}


/**
 *  创建 张江以外布局
 * @param req 
 * @param res 
 */
async function addZJBeyondLayout(req, res) {
    let reqConf = {city:"String", area:"Number", operationMode:"Number"};
    let { city, area, operationMode } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await zjBeyondLayoutBiz.createZJBeyondLayout(Uscc,  city, area, operationMode);

    res.success(result);

}


/**
 *  修改 张江以外布局
 * @param req 
 * @param res 
 */
async function updateZJBeyondLayout(req, res) {
    let reqConf = {id:"String", city:"String", area:"Number", operationMode:"Number"};
    let {id, city, area, operationMode } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await zjBeyondLayoutBiz.updateZJBeyondLayout(Uscc, id, city, area, operationMode );

    res.success(result);

}


/**
 *  回显 张江以外布局
 * @param req 
 * @param res 
 */
async function ZJBeyondLayoutInfo(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    let result = await zjBeyondLayoutBiz.selectZJBeyondLayout(id);

    res.success(result);

}

/**
 *  查询列表 张江以外布局
 * @param req 
 * @param res 
 */
async function ZJBeyondLayoutList(req, res) {
    const Uscc = req.headers.uscc;

    let result = await zjBeyondLayoutBiz.getZJBeyondLayoutListData(Uscc);

    res.success(result);

}

/**
 *  删除 张江以外布局
 * @param req 
 * @param res 
 */
async function deleteZJBeyondLayout(req, res) {
    let reqConf = {id: 'String' };//这里可以填0
    let { id } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let result = await zjBeyondLayoutBiz.deleteZJBeyondLayout(id);

    res.success(result);
}


/**
 *  机构资质 概览
 * @param req 
 * @param res 
 */
async function institutionAlnatureOverview(req, res) {
    const Uscc = req.headers.uscc;

    let result = await instiuQualifyBiz.overview(Uscc);

    res.success(result);

}