/**
 * 小程序端  孵化器入口  经营数据报表功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as fuHuaQiBusinessBiz from '../../biz/mobileFuHuaQi/fuHuaQi/fuHuaQiBusiness';
import { eccReqParamater } from '../../util/verificationParam';
import { checkFuHuaQiToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/fuhuaqi/business/addreport', checkFuHuaQiToken, asyncHandler(addreportBusiness));
    httpServer.post('/fuhuaqi/business/updatereport', checkFuHuaQiToken, asyncHandler(updatereportBusiness));
    httpServer.post('/fuhuaqi/business/deletereport', checkFuHuaQiToken, asyncHandler(deletereportBusiness));
    httpServer.post('/fuhuaqi/business/select', checkFuHuaQiToken, asyncHandler(selectBusiness));
}



/**
 *  添加孵化器经营数据
 * @param req 
 * @param res 
 */
async function addreportBusiness(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let monthInfo = fuHuaQiBusinessBiz.createBusiness(Uscc, form);
    res.success(monthInfo);
}


/**
 *  修改孵化器经营数据
 * @param req 
 * @param res 
 */
async function updatereportBusiness(req, res) {
    let reqConf = {form: 'Object' };
    let { form } = eccReqParamater(reqConf, req.body);
    const Uscc = req.headers.uscc;

    let monthInfo = fuHuaQiBusinessBiz.updateBusiness(Uscc, form);
    res.success(monthInfo);
}


/**
 *  删除孵化器经营数据
 * @param req 
 * @param res 
 */
async function deletereportBusiness(req, res) {
    const Uscc = req.headers.uscc;

    let monthInfo = fuHuaQiBusinessBiz.deleteBusiness(Uscc);
    res.success(monthInfo);
}


/**
 *  回显 孵化器经营数据
 * @param req 
 * @param res 
 */
async function selectBusiness(req, res) {
    const Uscc = req.headers.uscc;

    let monthInfo = await fuHuaQiBusinessBiz.selectBusiness(Uscc);
    res.success(monthInfo);
}
