/**
 * 小程序端  企业入口  用户基础功能路由
 */

import * as asyncHandler from 'express-async-handler';
import * as userBiz from '../../biz/mobileEnterprise/user';
import { eccReqParamater } from '../../util/verificationParam';
import { checkEnterpriseToken } from '../../middleware/user';

export function setRouter(httpServer) {
    httpServer.post('/enterprise/login', asyncHandler(login));
    httpServer.post('/enterprise/user/firstchangepwd', checkEnterpriseToken,  asyncHandler(firstLoginChangeEnterprisePwd));
}


/**
 * 企业登录 
 * @param req 
 * @param res 
 */
async function login(req, res) {
    let reqConf = {uscc:'String', pwd:'String'};
    let {uscc, pwd} = eccReqParamater(reqConf, req.body);
    
    let result = await userBiz.enterpriseLogin(uscc, pwd);

    res.success(result);
}


/**
 * 首次登录修改密码
 * @param req 
 * @param res 
 */
async function firstLoginChangeEnterprisePwd(req, res) {
    let reqConf = {confirmPwd:'String', pwd:'String'};
    let {confirmPwd, pwd} = eccReqParamater(reqConf, req.body);

    const Uscc = req.headers.uscc;
    
    let result = await userBiz.firstChangePwd(Uscc, pwd, confirmPwd);

    res.success(result);
}


