/**
 * 任务中心路由
 */

import * as asyncHandler from 'express-async-handler';
import * as fuHuaQiAdminBiz from '../../biz/admin/fuHuaQi/fuHuaQi';
import * as taskBiz from '../../biz/admin/fuHuaQi/task';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { eccReqParamater } from '../../util/verificationParam';


export function setRouter(httpServer) {
    httpServer.post('/admin/task/financingtasklist',checkGuanWeiHuiToken, asyncHandler(getFinancingTaskList));
    httpServer.post('/admin/task/enterprisetasklist',checkGuanWeiHuiToken, asyncHandler(getEnterpriseTaskList));
    /**导出 */
    httpServer.post('/admin/data/output/financingtasklist',checkGuanWeiHuiToken, asyncHandler(outPutFinancingTask));
    httpServer.post('/admin/data/output/enterprisetasklist',checkGuanWeiHuiToken, asyncHandler(outPutEnterpriseTaskList));
}


async function getFinancingTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        page: 'Number' 
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await taskBiz.financingTaskList(state, time, page);

    res.success(result);
}


async function getEnterpriseTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        page: 'Number' 
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, page} = eccReqParamater(reqConf, req.body, NotMustHaveKeys);

    let result = await taskBiz.addEnterpriseTaskList(state, time, page);

    res.success(result);
}


async function outPutFinancingTask(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        type:'Number',//下载类型
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys); 
    let {dataList, name} = await taskBiz.outPutFinancingTaskList(state, time, type);

    let fileName = `孵化器${name}融资企业任务列表.xlsx`;

    res.success({name:fileName, data:dataList});
}


async function outPutEnterpriseTaskList(req, res) {
    let reqConf = {
        state: 'Number', //状态
        time: 'Number',//数据月份
        type:'Number',//下载类型
    };
    const NotMustHaveKeys = ["state", "time"];
    let {state, time, type} = eccReqParamater(reqConf, req.body, NotMustHaveKeys); 
    let {dataList, name} = await taskBiz.outPutAddEnterpriseTaskList(state, time, type);

    let fileName = `孵化器${name}新迁入企业任务列表.xlsx`;

    res.success({name:fileName, data:dataList});
}