/**
 * 文件管理 路由
 */

import * as asyncHandler from 'express-async-handler';
import * as fileBiz from '../../biz/file';
import { checkGuanWeiHuiToken } from '../../middleware/user';
import { parseFormParam } from '../../middleware/fromParam';


export function setRouter(httpServer) {
    httpServer.post('/admin/files/policy/up', checkGuanWeiHuiToken, parseFormParam, asyncHandler(upPolicyBackground));
}

async function upPolicyBackground(req, res) {
    let result = await fileBiz.upFile( req.files, req.fileType);
    res.success(result);
}
