/**
 * 孵化器信息表
 * operationName不可修改 2023-02-06 确定此需求
 * uscc不可修改 2023-02-06 确定此需求
 * 首次登录要求改密码 不改密码不能继续操作 2023-02-07 确定此需求
 * 管理后台列表页面一页展示10条 2023-02-08 确定此需求
 * 孵化器账号不能被删除 只能被禁用 2023-02-08 确定此需求
 */

import { mySqlTableClass } from "../../db/mysql/mysqlClass";

/**表结构 */
const TableConfig = {
    name:'string',//名称
    operationName:'string',//运营机构名称  不可修改
    uscc:'string',//统一信用代码 也是登录账号 不可修改
    virtualEnterpriseNum:'number',//虚拟企业数量
    logonTime:'number',//注册时间
    incubatedAcreage:'number',//在孵面积(㎡)
    acreageTotal:'number',//孵化器总面积(㎡)
    acreagePersonalUse:'number',//孵化器自用面积(㎡)
    lv:'number',//孵化器级别
    identificationTime:'number',//认定时间
    industry:'string',//孵化领域
    institutionalNature:'number',//机构性质
    liaison:'string',//联系人
    liaisonPhone:'string',//联系电话
    personInCharge:'string',//负责人
    personInChargePhone:'string',//负责人联系电话
    // hatchingGround:{type:[hatchingGroundSchema], default:[] },//经备案孵化场地
    /**登录相关 */
    pwd:'string',//登录密码
    token:'string',
    tokenMs:'number',
    firstLoginIsChangePwd:'boolean',//首次登录是否修改密码
    createTime:'number',
    userState:'boolean' //是否禁用
}

/**sql */
enum SQLENUM {

}
/**多表sql */
enum MORETABLESQLENUM {

}

let financingModel;

export function initModel() {
    financingModel = new mySqlTableClass("fuhuaqi", TableConfig, SQLENUM, MORETABLESQLENUM);
}
