import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "../util/bizError";

var formidable = require("formidable");
const path = require('path');

export async function parseFormParam(req, res, next) {
    var form = new formidable.IncomingForm();
    form.uploadDir = path.join(__dirname.substring(0,__dirname.indexOf("out")), 'files');
    form.parse(req, (err, fields, files)=>{
        if (err) {
            next(err)
        }
        else {
            req.fields = fields;
            req.files = files;
            if (!files.file) {
                return next(new BizError(ERRORENUM.文件上传失败) )
            }
            if ( files.file.type == 'image/png') {
                req.fileType = '.png';
                next();
            } else if (files.file.type == 'image/jpg' || files.file.type == 'image/jpeg') {
                req.fileType = '.jpg';
                next();
            } else {
                return next(new BizError(ERRORENUM.只能上传png或jpg图片) )
            }
            
            
        }
    })
}