/**
 * 张江以外布局情况
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';


const zjBeyondLayoutSchema = new Schema({
    id:{type:String, index:true},//标识
    uscc:{type:String, index:true},//孵化器uscc
    name:{type:String, index:true},//运营机构名称
    city:String,//布局城市
    area:Number,//空间面积
    operationMode:Number,//运营模式
});

var zjBeyondLayoutModel;
export function initModel(){
    zjBeyondLayoutModel = baseDB.model('zjBeyondLayout', zjBeyondLayoutSchema);
    zjBeyondLayoutModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await zjBeyondLayoutModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}
 

export async function findOneData(id:string) {
    return await zjBeyondLayoutModel.selectOnceData({id});
}

export async function findListDataByParam(param) {
    return await zjBeyondLayoutModel.find(param);
}

export async function deleteDataById(id:string) {
    await zjBeyondLayoutModel.deleteOne({id});   
}

export async function addData(id:string, uscc:string, name:string, city:string, area:number, operationMode:number) {
    let addInfo = {id, uscc, name, city, area, operationMode};
    await zjBeyondLayoutModel.create(addInfo);
}

export async function getCount(uscc:string) {
    return await zjBeyondLayoutModel.find({uscc}).count();
}
