/**
 * 创业老师
 */


import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';



const startupTeacherSchema = new Schema({
    id:{type:String, index:true},//标识
    uscc:{type:String, index:true},//孵化器uscc
    name:{type:String, index:true},//运营机构名称
    teacherName:String,//导师名称
    unit:String,//单位
    duties:String,//职务
    speciality:{type:[Number], default:[]},//专业特长
    teacherLv:Number,//导师级别
    serviceEnterprises:String,//服务企业名单
});

var startupTeacherModel;
export function initModel(){
    startupTeacherModel = baseDB.model('startupTeacher', startupTeacherSchema);
    startupTeacherModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await startupTeacherModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

export async function findOneData(id:string) {
    return await startupTeacherModel.selectOnceData({id});
}

export async function findListDataByParam(param) {
    return await startupTeacherModel.find(param);
}

export async function deleteDataById(id:string) {
    await startupTeacherModel.deleteOne({id});   
}

export async function addData(id:string, uscc:string, name:string, teacherName:string, unit:string, duties:string, speciality, teacherLv:number, serviceEnterprises:string) {
    let addInfo = {id, uscc, name, teacherName, unit, duties, speciality, teacherLv, serviceEnterprises};
    await startupTeacherModel.create(addInfo);
}

export async function getCount(uscc:string) {
    return await startupTeacherModel.find({uscc}).count();
}
