/**
 * 大学/科研院所合作机构
 */


import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';


const icrSchema = new Schema({
    id:{type:String, index:true},//标识
    uscc:{type:String, index:true},//孵化器uscc
    name:{type:String, index:true},//运营机构名称
    po:String,//合作机构
    ce:String,//合作企业
    cMode:{type:[Number], default:[]},//合作方式
    cAchievements:String,//合作成果
    startTimeMs:Number,//开始时间
});

var icrModel;
export function initModel(){
    icrModel = baseDB.model('icr', icrSchema);
    icrModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await icrModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

export async function findOneData(id:string) {
    return await icrModel.selectOnceData({id});
}

export async function findListDataByParam(param) {
    return await icrModel.find(param);
}

export async function deleteDataById(id:string) {
    await icrModel.deleteOne({id});   
}

export async function addData(id:string, uscc:string, name:string, po:string, ce:string, cMode, cAchievements:string, startTimeMs:number) {
    let addInfo = {id, uscc, name, po, ce, cMode, cAchievements, startTimeMs};
    await icrModel.create(addInfo);
}

export async function getCount(uscc:string) {
    return await icrModel.find({uscc}).count();
}
