/**
 * 国际化登记
 * 
 */

import {Schema} from 'mongoose';
import { baseDB } from '../../../db/mongo/dbInit';


const i18nRegisterSchema = new Schema({
    id:{type:String, index:true},//标识
    uscc:{type:String, index:true},//孵化器uscc
    name:{type:String, index:true},//运营机构名称
    country:String,//国家
    partners:String,//合作机构
    cMode:String,//合作方式
    cAchievements:String,//合作成果
});

var i18nRegisterModel;
export function initModel(){
    i18nRegisterModel = baseDB.model('fuHuaQiI18nRegister', i18nRegisterSchema);
    i18nRegisterModel.selectOnceData = async function (paramater:object) {
        let selectInfo = await i18nRegisterModel.findOne(paramater).exec();
        if (selectInfo) {
            if (!selectInfo.runSave) {
                selectInfo.runSave = selectInfo.save;
                selectInfo.save = save.bind(selectInfo)
            }
        }
        return selectInfo;
    }
}
export async function save(throwError=false) {
    if (!this.isModified()) return;
    await this.runSave({validateBeforeSave:false}).catch(err=>{
        console.log(err);
    });
}

export async function findOneI18nRegister(id:string) {
    return await i18nRegisterModel.selectOnceData({id});
}

export async function findI18nRegisterListByParam(param) {
    return await i18nRegisterModel.find(param);
}

export async function deleteI18nRegisterListById(id:string) {
    await i18nRegisterModel.deleteOne({id});   
}

export async function addRegister(id:string, uscc:string, name:string, country:string, partners:string, cMode:string, cAchievements:string) {
    let addInfo = {id, uscc, name, country, partners, cMode, cAchievements};
    await i18nRegisterModel.create(addInfo);
}

export async function getCount(uscc:string) {
    return await i18nRegisterModel.find({uscc}).count();
}