/**
 * 校验表单参数配置
 * 使用场景：  验证客户端请求参数
 *     限制：  1.使用端不同不能共用一份配置
 *             2.需要搭配 util/verificationParam -> eccFormParam() 方法使用
 *     说明:   notMustHave = true 时说明该字段是非必填的;不配该字段说明是必填的
 */


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     更新孵化器基础数据表单
 * 备注:   
 */
export const BaseParamUpdateConfig = {
    virtualEnterpriseNum:{type:"Number", notMustHave:true},//虚拟企业数量
    incubatedAcreage:{type:"Number", notMustHave:true},//在孵面积(㎡)
    acreageTotal:{type:"Number", notMustHave:true},//孵化器总面积(㎡)
    acreagePersonalUse:{type:"Number", notMustHave:true},//孵化器自用面积(㎡)
    hatchingGround:{type:"[Object]", notMustHave:true},//经备案孵化场地
    // isProfessionalTechnology:{type:"Boolean", notMustHave:true},//是否专业技术平台
    // professionalTechnologyName:{type:"String", notMustHave:true},//专业技术平台名称
    cooperationInstitutions:{type:"String", notMustHave:true},//合作机构名称
    isCooperation:{type:"Boolean", notMustHave:true},//是否与第三方机构合作
    // professionalTechnologyCreateTime:{type:"Number", notMustHave:true},//时间  年份 xxxx年01月01日 的时间戳
    // professionalTechnologyAmount:{type:"Number", notMustHave:true},//投资金额 万元
};
/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     验证经备案孵化场地
 * 备注:     当填了案孵化场地数据 验证经备案孵化场地
 */
export const BaseParamUpdateHatchingGroundConfig = {
    // personInChargeAdd:{type:"String"},//孵化场地地址  2.1舍弃 修改为 personInChargeAddress
    personInChargeAddress:{type:"Address"},//孵化场地地址
    siteAcreage:{type:"Number"},//孵化场地面积(㎡)
    leasePrice:{type:"Number"},//孵化场地出租单价
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     更新孵化器机构信息数据表单
 * 备注:   
 */
export const OrganizationParamUpdateConfig = {
    name:{type:"String", notMustHave:true},// {key:"名称"},
    operationName:{type:"String"},// {key:"运营机构名称"},
    uscc:{type:"String"},// {key:"统一信用代码"},
    logonTime:{type:"Number", notMustHave:true},// {key:"注册时间", changeDate:true},
    lv:{type:"Number", notMustHave:true},// {key:"孵化器级别"},
    identificationTime:{type:"Number", notMustHave:true},// {key:"认定时间", changeDate:true},
    industry:{type:"[Number]", notMustHave:true},// {key:"孵化领域"},
    institutionalNature:{type:"Number", notMustHave:true},// {key:"机构性质"},
    operationModel:{type:"[Number]", notMustHave:true},// {key:"运营模式"},//新加
    foundingTeam:{type:"[Object]", notMustHave:true},// {key:"创始团队"},//新加
    liaison:{type:"String", notMustHave:true},// {key:"联系人"},
    liaisonPhone:{type:"String", notMustHave:true},// {key:"联系电话"},
    // personInCharge:{type:"String", notMustHave:true},// {key:"负责人"},  2.0去掉了
    // personInChargePhone:{type:"String", notMustHave:true},// {key:"负责人联系电话"},  2.0去掉了
    operationModelDes:{type:"String", notMustHave:true},//{key:"运营模式描述"},
    foundingTeamType:{type:"Number", notMustHave:true},//{key:"团队类型"}
    introduction:{type:"String",  notMustHave:true},//孵化器简介        2.3新加
};
/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     机构信息中的创始团队
 * 备注:     更新机构信息时 当选择了创始团队
 */
export const OrganizationParamFoundingTeamUpdateConfig = {
    memberName:{type:"String"},//成员姓名
    memberSex:{type:"Number"},//成员性别
    memberAge:{type:"Number"},//成员年龄
    memberDEGREE:{type:"Number"},//成员最高学历
    memberSchool:{type:"String"},//毕业学校
    des:{type:"String"},//履历描述
};



/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     修改新注册企业的表单
 * 备注:     全必填
 */
export const EnterpriseParamFormConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    logonAddress:"Address",//注册地址 2.1修改
    operatingAddress:"Address",//经营地址  2.1修改
    leasedArea:"Number",//租赁面积（平方米）
    mainBusiness:"String",//主营业务
    draftId:"String",//草稿id
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     修改新迁入企业的表单
 * 备注:     全必填
 */
export const EnterpriseInPutParamFormConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    logonAddress:"Address",//注册地址 2.1修改
    operatingAddress:"Address",//经营地址 2.1修改
    leasedArea:"Number",//租赁面积（平方米）
    oldLogonAddress:"Address",//迁入前注册地址 2.1修改
    timeOfImmigration:"Number",//迁入时间
    mainBusiness:"String",//主营业务
    draftId:"String",//草稿id
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     新注册企业的表单
 * 备注:     全必填
 */ 
export const RegisterEnterpriseParamConfig = {
    name:{type:"String"}, //企业名称
    uscc:{type:"String"}, //统一信用代码
    industry:{type:"[Number]"},//领域
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAddress:{type:"Address"},//注册地址 2.1修改
    operatingAddress:{type:"Address"},//经营地址 2.1修改
    leasedArea:{type:"Number"},//租赁面积（平方米）
    mainBusiness:{type:"String"},//主营业务
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     迁入企业登记表单
 * 备注:     全必填
 */
export const MoveInEnterpriseParamConfig = {
    name:"String", //企业名称
    uscc:"String", //统一信用代码
    industry:"[Number]",//领域
    logonTime:"Number",//注册时间
    firstIncubationTime:"Number",//首次入孵时间
    timeOfImmigration:"Number",//迁入时间
    isNaturalPersonHolding:"Boolean",//是否自然人控股企业
    oldLogonAddress:"Address",//迁入前注册地址 2.1修改
    logonAddress:"Address",//注册地址 2.1修改
    operatingAddress:"Address",//经营地址 2.1修改
    leasedArea:"Number",//租赁面积（平方米）
    mainBusiness:"String",//主营业务
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     更新融资企业登记表单
 * 备注:   
 */
export const FinancingParamUpdateConfig = {
    uscc:{type:"String"}, //统一信用代码
    name:{type:"String"},//企业名称
    logonAddress:{type:"Address"},//注册地址
    operatingAddress:{type:"Address"},//经营地址
    financingAmount:{type:"Number"},//融资金额(万元)
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间
    fuHuaQiInvestment:{type:"Boolean"}, //孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number", notMustHave:true},//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:{type:"Number", notMustHave:true},//孵化器投资方式
    financingRounds:{type:"Number"},//融资轮次
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     创建融资企业登记
 * 备注:     
 */
 export const FinancingParamConfig = {
    name:{type:"String"},//企业名称
    logonAddress:{type:"Address"},//注册地址
    operatingAddress:{type:"Address"},//经营地址
    financingAmount:{type:"Number"},//融资金额(万元)
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间
    fuHuaQiInvestment:{type:"Boolean" }, //孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number", notMustHave:true },//孵化器投资金额(万元)
    fuHuaQiInvestmentStyle:{type:"Number", notMustHave:true },//孵化器投资方式
    financingRounds:{type:"Number"},//融资轮次
};


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     创建融资企业登记选择了孵化器投资
 * 备注:     
 */
export const FinancingParamSubConfig = {
    fuHuaQiInvestmentAmount:{type:"Number"},
    fuHuaQiInvestmentStyle:{type:"Number"}
}


/**
 * 使用端:   管理后台
 * 场景:     新增孵化器账号
 * 备注:     所有参数为必填
 */
export const FuHuaQiUserConfig = {
    operationName:{type:"String" },//运营机构名称
    uscc:{type:"String" },//营业执照 
    personInChargePhone:{type:"String" },//负责人手机号
    personInCharge:{type:"String" }//负责人 
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     修改我的企业列表里的 我的企业信息
 * 备注:     所有参数为必填
 */
export const UpdateMyEnterpriseBaseDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAddress:{type:"Address"},//注册地址
    operatingAddress:{type:"Address"},//经营地址
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     我的企业列表里的 补录 迁入企业
 * 备注:     所有参数为必填
 */
export const ReplenishMyEnterpriseInPutDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAddress:{type:"Address"},//注册地址
    operatingAddress:{type:"Address"},//经营地址
    leasedArea:{type:"Number"},//租赁面积（平方米）
    timeOfImmigration:{type:"Number"},//迁入时间
    oldLogonAddress:{type:"Address"},//迁入前注册地址
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     我的企业列表里的 补录 新注册企业
 * 备注:     所有参数为必填
 */
export const ReplenishMyEnterpriseCreateDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAddress:{type:"Address"},//注册地址
    operatingAddress:{type:"Address"},//经营地址
    leasedArea:{type:"Number"},//租赁面积（平方米）
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     创建新的融资信息
 * 备注:     所有参数为必填
 */
export const EnterpriseCreateFinancingDataConfig = {
    financingRounds:{type:"Number"},//融资轮次
    financingAmount:{type:"Number"}, //融资金额_单位 万元
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间时间戳
    fuHuaQiInvestment:{type:"Boolean"},//孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number"},//孵化器投资金额_单位 万元
    fuHuaQiInvestmentStyle:{type:"Number"},//孵化器投资方式
}

/**
 * 使用端:   小程序端【企业入口】
 * 场景:     创建新的融资信息选择了孵化器投资
 * 备注:     
 */
export const EnterpriseCreateFinancingParamSubConfig = {
    fuHuaQiInvestmentAmount:{type:"Number"},
    fuHuaQiInvestmentStyle:{type:"Number"}
}



/**
 * 使用端:   小程序端【企业入口】
 * 场景:     修改融资信息
 * 备注:     所有参数为必填
 */
export const EnterpriseUpdateFinancingDataConfig = {
    id:{type:"String"},//id
    financingRounds:{type:"Number"},//融资轮次
    financingAmount:{type:"Number"}, //融资金额_单位 万元
    investmentInstitutionsName:{type:"String"},//投资机构名称
    timeToObtainInvestment:{type:"Number"},//获得投资时间时间戳
    fuHuaQiInvestment:{type:"Boolean"},//孵化器是否投资
    fuHuaQiInvestmentAmount:{type:"Number"},//孵化器投资金额_单位 万元
    fuHuaQiInvestmentStyle:{type:"Number"},//孵化器投资方式
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     修改企业信息
 * 备注:     所有参数为必填
 */
export const EnterpriseUpdateBaseDataConfig = {
    name:{type:"String"},//企业名称
    uscc:{type:"String"},//统一信用代码
    industry:{type:"[Number]"},//领域
    mainBusiness:{type:"String"},//主营业务
    logonTime:{type:"Number"},//注册时间
    firstIncubationTime:{type:"Number"},//首次入孵时间
    isNaturalPersonHolding:{type:"Boolean"},//是否自然人控股企业
    logonAddress:{type:"Address"},//注册地址
    operatingAddress:{type:"Address"},//经营地址
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     申报经营数据
 * 备注:     所有参数为必填
 */
export const EnterpriseAddBusinessDataConfig = {
    BI:{type:"Number"},//营业收入
    RD:{type:"Number"},//研发投入
    TXP:{type:"Number"},//纳税
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     申报团队信息数据
 * 备注:     所有参数为必填
 */
export const EnterpriseAddTeamDataConfig = {
    doctor:{type:"Number"},//博士
    master:{type:"Number"},//硕士
    undergraduate:{type:"Number"},//本科
    juniorCollege:{type:"Number"},//专科
    other:{type:"Number"},//其他
    studyAbroad:{type:"Number"},//留学人数
    graduates:{type:"Number"},//应届毕业生
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     修改企业创始团队
 * 备注:     所有参数为必填
 */
export const InitialTeamUpdateConfig = {
    id:{type:"String"},//标识
    type:{type:"Number"},//创始团队人才类型
    memberName:{type:"String"},//成员姓名
    memberSex:{type:"Number"},//成员性别
    memberAge:{type:"Number"},//成员年龄  出生年月时间戳
    memberDEGREE:{type:"Number"},//成员最高学历
    memberSchool:{type:"String"},//毕业学校
    des:{type:"String"},//履历描述
}


/**
 * 使用端:   小程序端【企业入口】
 * 场景:     企业修改资质信息
 * 备注:     所有参数为必填
 */
export const EnterpriseQualificationUpdateConfig = {
    isHighTech:{type:"Boolean"},
    highTechMs:{type:"Number"},//高新技术
    isZjtx:{type:"Boolean"},
    zjtxMs:{type:"Number"},//专精特新
    isXjrpy:{type:"Boolean"},
    xjrpyMs:{type:"Number"},//小巨人培育
    isXjr:{type:"Boolean"},
    xjrMs:{type:"Number"},//小巨人
    beOnTheMarket:{type:"[Number]", notMustHave:true},//上市情况
    isBeOnTheMarket:{type:"Boolean"}
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     孵化器补充企业团队信息
 * 备注:     所有参数为必填
 */
export const FuHuaQiReplenishEnterpriseTeamDataConfig = {
    doctor:{type:"Number" },//博士
    master:{type:"Number" },//硕士
    undergraduate:{type:"Number" },//本科
    juniorCollege:{type:"Number" },//专科
    other:{type:"Number" },//其他
    studyAbroad:{type:"Number"},//留学人数
    graduates:{type:"Number"},//应届毕业生
}


/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     孵化器补充经营数据
 * 备注:     所有参数为必填
 */
export const FuHuaQiReplenishEnterpriseBusinessDataConfig = {
    BI:{type:"Number"},//营业收入
    RD:{type:"Number"},//研发投入
    TXP:{type:"Number"},//纳税
}



/**
 * 使用端:   小程序端【孵化器入口】
 * 场景:     孵化器补充经营数据
 */
export const FuHuaQiBusinessDataConfig = {
    TR:{type:"Number"},//综合收入
    ROR:{type:"Number"},//投资收入
    RR:{type:"Number"},//租金收入
    FS:{type:"Number"},//财政补贴
    MIS:{type:"Number"},//其他
    NP:{type:"Number"},//净利润
    TP:{type:"Number"},//纳税
}